/*
* ============================================================================
*  Name     : CTaskManagerApp from TaskManagerApp.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Description:
*     Declares main application class.
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __TASKMANAGERAPP_H__
#define __TASKMANAGERAPP_H__

// INCLUDE FILES
#include <aknapp.h>

// CONSTANTS
// UID of the application

#ifdef __SERIES60_30__
// For S60 3rd Edition
const TUid KUidTaskManagerApp = { 0xE246da04 };
#else
// For S60 1st/2nd Edition
const TUid KUidTaskManagerApp = { 0x0246da04 };
#endif


// CLASS DECLARATION

/**
* CTaskManagerApp application class.
* Provides factory to create concrete document object.
* 
*/
class CTaskManagerApp : public CAknApplication
    {
private: // Functions from base classes

    /**
    * From CApaApplication, creates CTaskManagerDocument document object.
    * @return A pointer to the created document object.
    */
    CApaDocument* CreateDocumentL();
    
    /**
    * From CApaApplication, returns application's UID (KUidTaskManagerApp).
    * @return The value of KUidTaskManagerApp.
    */
    TUid AppDllUid() const;
    };

#endif // __TASKMANAGERAPP_H__

// End of File

