/*
* ============================================================================
*  Name     : CTaskManagerConnForm from TaskManagerConnForm.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef TASKMANAGERCONNFORM_H
#define TASKMANAGERCONNFORM_H

// INCLUDE FILES
#include <AknForm.h>
#include <e32base.h>

// FORWARD DECLARATIONS
class TTaskManagerConnInfo;

// CLASS DECLARATION

/**
* A form class for querying the connection settings from the user.
*
*/
class CTaskManagerConnForm : public CAknForm
	{
public: // New functions

	/**
	* Runs and destroys the form.
	* @param aConnInfo is where the connections setting defined by the user are set.
	* @return ETrue if OK was pressed, EFalse if not.
	*/
	static TBool RunDlgLD( TTaskManagerConnInfo& aConnInfo );
	
private: // Functions from base classes

	/**
	* From CAknForm, OkToExitL.
	*/
	TBool OkToExitL( TInt aButtonId );
	
	/**
	* From CEikDialog, PreLayoutDynInitL.
	*/
	void PreLayoutDynInitL();

private:
	
	/**
	* Symbian OS Default constructor.
	*/
	CTaskManagerConnForm( TTaskManagerConnInfo& aConnInfo );

private: // Data members

	TTaskManagerConnInfo& iConnInfo;
	
	};
	
// End of file


#endif

