package com.forum.nokia.taskmanager.beans;

import java.util.List;

import com.forum.nokia.taskmanager.database.DBAccess;

/**
 * An interface bean-class for the JSP-pages to gain access into the database.
 * This class works as a middle entity between the actual database communicator
 * (class DBAccess) and the JSP page. Since JSP can only communicate with
 * classes that obey the bean model (assuming were using JSTL and EL instead of
 * JSP scriplets, as recommended in JSP 2.0 specification), we need a middle
 * entity like this. This arrangement makes it possible to truly separate the
 * view from the model (see "MVC architecture" and "Java Model 2 architecture").
 */
public class GroupBean
{
    /**
     * The DBAO.
     */
    private DBAccess database = null;

    /**
     * Default constructo. Mandatory in a JavaBean.
     */
    public GroupBean()
    {
    }

    /**
     * Setter for the DBAO.
     * 
     * @param db
     *            The DBAO.
     */
    public void setDatabase( DBAccess db )
    {
        this.database = db;
    }

    /**
     * Returns a list of all possible groups in the system.
     * 
     * @return A list of groups.
     */
    public List getGroups()
    {
        return database.getGroups();
    }
}
