package com.forum.nokia.taskmanager.beans;

/**
 * This struct-style JavaBean class represents a single task.
 */
public class Task
{
    /**
     * Task attributes.
     */
    private String owner;

    private String ownerId;

    private String description;

    private String status;

    private String taskId;

    /**
     * Default constructor. Mandatory in a JavaBean.
     */
    public Task()
    {
    }

    /**
     * Constructor for a multitude of data.
     * 
     * @param owner
     *            Task owner username.
     * @param ownerId
     *            Id of the owner.
     * @param description
     *            Task description.
     * @param status
     *            Status of the task.
     * @param taskId
     *            Id number of the task.
     */
    
    public Task( String owner, String ownerId, String description,
            String status, String taskId )
    {
        this.owner = owner;
        this.ownerId = ownerId;
        this.description = description;
        this.status = status;
        this.taskId = taskId;
    }

    /**
     * Getter for owner.
     * 
     * @return Owner username.
     */
    public String getOwner()
    {
        return owner;
    }

    /**
     * Getter for owner id number.
     * 
     * @return Owner id number.
     */
    public String getOwnerId()
    {
        return ownerId;
    }

    /**
     * Getter for task description.
     * 
     * @return Description of task.
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Getter for task state.
     * 
     * @return State of task.
     */
    public String getStatus()
    {
        return status;
    }

    /**
     * Getter for task id number.
     * 
     * @return Task id number.
     */
    public String getTaskId()
    {
        return taskId;
    }
}
