package com.forum.nokia.taskmanager.beans;

import java.util.List;

import com.forum.nokia.taskmanager.database.DBAccess;

/**
 * An interface bean-class for the JSP-pages to gain access into the database.
 * This class works as a middle entity between the actual database communicator
 * (class DBAccess) and the JSP page. Since JSP can only communicate with
 * classes that obey the bean model (assuming were using JSTL and EL instead of
 * JSP scriplets, as recommended in JSP 2.0 specification), we need a middle
 * entity like this. This arrangement makes it possible to truly separate the
 * view from the model (see "MVC architecture" and "Java Model 2 architecture").
 */
public class TaskListBean
{
    /**
     * The DBAO.
     */
    private DBAccess database = null;

    private String user_id = "";

    private String task_id = "";

    /**
     * Default constructor. Mandatory in a JavaBean.
     */
    public TaskListBean()
    {
    }

    /**
     * Setter for the DBAO.
     * 
     * @param database
     *            The DBAO.
     */
    public void setDatabase( DBAccess database )
    {
        this.database = database;
    }

    /**
     * Setter for the user id number, used in getting a specified users tasks.
     * 
     * @param user_id
     *            The id number of the user.
     */
    public void setUserId( String user_id )
    {
        this.user_id = user_id;
    }

    /**
     * Setter for the task id number, used in marking a task as done.
     * 
     * @param task_id
     *            The id number of the task.
     */
    public void setTaskId( String task_id )
    {
        this.task_id = task_id;
    }

    /**
     * Gets tasks for a certain user.
     * 
     * @return A list of tasks.
     */
    public List getUserTasks()
    {
        return database.getTasks( user_id );
    }

    /**
     * Gets all tasks for all users.
     * 
     * @return A list of tasks.
     */
    public List getAllTasks()
    {
        return database.getTasks();
    }
}
