package com.forum.nokia.taskmanager.beans;

/**
 * This struct-style JavaBean class represents a single user.
 */
public class User
{
    /**
     * User attributes.
     */
    private String userId;

    private String username;

    private String mobile;

    private String groupId;

    private String groupname;

    /**
     * Default constructor. Mandatory in a JavaBean.
     */
    public User()
    {
    }

    /**
     * A constructor for multiple arguments.
     * 
     * @param userId Id number of the user.
     * @param username Name of the user.
     * @param mobile Mobile number of the user.
     * @param groupname Name of the group the user belongs to.
     * @param groupId Id number of the group the user belongs to.
     */
    public User( String userId, String username, String mobile,
            String groupname, String groupId )
    {
        this.userId = userId;
        this.username = username;
        this.mobile = mobile;
        this.groupname = groupname;
        this.groupId = groupId;
    }

    /**
     * Getter for user id.
     * @return The users id.
     */
    public String getUserId()
    {
        return userId;
    }

    /**
     * Getter for username.
     * @return The users name.
     */
    public String getUsername()
    {
        return username;
    }

    /**
     * Getter for the users group name.
     * @return Users group name.
     */
    public String getGroupname()
    {
        return groupname;
    }

    /**
     * Getter for the users group id.
     * @return Users group id.
     */
    public String getGroupId()
    {
        return groupId;
    }

    /**
     * Getter for users mobile.
     * @return Users mobile number.
     */
    public String getMobile()
    {
        return mobile;
    }
}
