package com.forum.nokia.taskmanager.beans;

import java.sql.SQLException;
import java.util.List;

import com.forum.nokia.taskmanager.database.DBAccess;

/**
 * An interface bean-class for the JSP-pages to gain access into the database.
 * This class works as a middle entity between the actual database communicator
 * (class DBAccess) and the JSP page. Since JSP can only communicate with
 * classes that obey the bean model (assuming were using JSTL and EL instead of
 * JSP scriplets, as recommended in JSP 2.0 specification), we need a middle
 * entity like this. This arrangement makes it possible to truly separate the
 * view from the model (see "MVC architecture" and "Java Model 2 architecture").
 */
public class UserBean
{
    /**
     * The database access object (DBAO).
     */
    private DBAccess database = null;
    
    private String username;
    private String password;

    /**
     * Retrieving the list of users to be sent an SMS requires two function
     * invocations. For that reason we need a member variable to store data
     * between the invocations.
     */
    int smsListSize = -1;

    /**
     * The default constructor, made mandatory by the JavaBeans model.
     */
    public UserBean()
    {
    }

    /**
     * This setter function sets the database access object into place.
     * 
     * @param db
     *            The database access object (DBAO).
     */
    public void setDatabase( DBAccess db )
    {
        this.database = db;
    }

    /**
     * Retrieves a list of worker- and manager-type users from the database
     * through the DBAO.
     * 
     * @return A list of users.
     */
    public List getUsers()
    {
        return database.getTaskUsers();
    }

    /**
     * Gets a list of users that need to be sent an SMS to inform them of
     * changes in the task list.
     * 
     * @return A list of users.
     */
    public List getSmsUsers()
    {
        List list = database.smsUsers();
        smsListSize = list.size();
        return list;
    }

    /**
     * A separate function is needed to return the quantity of users that will
     * have to be sent an SMS.
     * @return The length of the list returned in the previous function. 
     */
    public int getSmsUserListSize()
    {
        return smsListSize;
    }

    /**
     * Returns a list of ALL users in the system, including the administrators.
     * @return A list of users.
     */
    public List getAllUsers()
    {
        return database.getAllUsers();
    }
    
    public void setUsername( String username )
    {
        this.username = username;
    }
    
    public void setPassword( String password )
    {
        this.password = password;
    }
    
    public String getIdentifiedUser()
    {
        String userId = null;
        try
        {
            userId = database.validateUser( username, password ).userId;
        }
        catch( SQLException e )
        {
        }
        return userId;
    }
}
