<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
<title>Tasks</title>
<link rel="stylesheet" type="text/css" href="style.css" />

<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1" session="true" errorPage="" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<!-- User role is determined and set as an EL expression. -->
<c:set var="userRole" value="${sessionScope['userRole']}" />
<c:choose>
	<c:when test="${userRole == '1'}">
		<c:set var="role" value="administrator" scope="request" />
<%@ include file="/javascript/admin_js.jsp" %>
	</c:when>
	<c:when test="${userRole == '2'}">
		<c:set var="role" value="manager" scope="request" />
<%@ include file="/javascript/manager_js.jsp" %>
	</c:when>
	<c:when test="${userRole == '3'}">
		<c:set var="role" value="worker" scope="request" />
<%@ include file="/javascript/worker_js.jsp" %>
	</c:when>
</c:choose>

</head>

<body>

<%@ include file="/check_login.jsp" %>

<!-- UserBean is used by administrator_main.jsp and left_column.jsp to retrieve
user data from the database. -->
<jsp:useBean id="userBean"
		  	 class="com.forum.nokia.taskmanager.beans.UserBean"
		  	 scope="request">
	<jsp:setProperty name="userBean" property="database"
			  		 value="${database}" />
</jsp:useBean>

<!-- TaskBean is used for getting tasks from the database. -->
<jsp:useBean id="taskBean"
   		     class="com.forum.nokia.taskmanager.beans.TaskListBean"
             scope="request">
	<jsp:setProperty name="taskBean" property="database"
	                 value="${database}"/>
</jsp:useBean>

<!-- MAIN TABLE -->
<table align="center" class="main_table">

	<!-- FIRST ROW IN MAIN TABLE -->
	<%@ include file="/static_includes/header.jsp" %>

	<!-- SECOND ROW IN MAIN TABLE -->
	<tr>
		<!-- LEFT COLUMN -->
		
		<%@ include file="/static_includes/left_column.jsp" %>

		<!-- MIDDLE COLUMN -->
		<td align="center" class="middle_col">

		<c:set var="i" scope="request" value="0" />
		<c:set var="row" scope="request" value="even_row" />

<c:choose>
	<c:when test="${role == 'administrator'}">
		<%@ include file="/administrator_main.jsp" %>
	</c:when>
	<c:when test="${role == 'manager'}">
		<%@ include file="/manager_main.jsp" %>
	</c:when>
	<c:when test="${role == 'worker'}">
		<%@ include file="/worker_main.jsp" %>
	</c:when>
</c:choose>

<c:if test="${role == 'manager'}">
	<form name="sms" action="Controller?action=SendSMSAction" method=POST>
		<div class="right"><input type=SUBMIT class="button" value="Send SMS"></div>
	</form>
</c:if>
<font color="#FF0000">
<c:out value="${sessionScope['sqlError']}" default="" />

<c:if test="${role == 'manager' and requestScope['smsSent'] == 'true'}">
SMS sent to users:<br>

	<c:forEach var="user" items="${userBean.smsUsers}">
<c:out value="${user.username}" /><br>
	</c:forEach>
	
	<c:if test="${userBean.smsUserListSize == 0}">
No SMS messages sent. All users had data up to date.
	</c:if>
</c:if>
</font>
</td>


		<!-- RIGHT COLUMN -->
		<%@ include file="/static_includes/right_column.jsp" %>
	</tr>
</table>

</body>
</html>
