/*
* ============================================================================
*  Name     : CTaskManagerAppView from TaskManagerAppView.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __TASKMANAGER_APPVIEW_H__
#define __TASKMANAGER_APPVIEW_H__

// INCLUDE FILES
#include "TaskManagerEngine.h"

#include <eiklbo.h> // MEikListBoxObserver
#include <coecntrl.h>

// CONSTANTS
const TInt KMaxStatusTextLength = 25;

// FORWARD DECLARATIONS
class CAknSingleStyleListBox;
class CTaskManagerAppUi;
class CResponse;

// CLASS DECLARATION

/**
* A container class that shows tasks to user and responds to notifications.
*
*/
class CTaskManagerAppView : public CCoeControl, 
							public MEikListBoxObserver, 
							public MTransactionObserver
	{
public: // Constructors and destructor

	/**
	* Two-phased constructor.
	*/
	static CTaskManagerAppView* NewL(const TRect& aRect, CTaskManagerAppUi& aAppUi);

	/**
	* Destructor.
	*/
     ~CTaskManagerAppView();


public: // New functions

	/**
	* Shows a list of IAPs to user for choosing the one to be used.
	* @param aId id of the IAP that the user chose.
	* @param aDefaultId IAP with this id is highlighted in the list query.
	* @return ETrue if user chose an IAP, EFalse if not.
	*/
	TBool QueryIapL(TUint32& aId, const TUint32& aDefaultId);

private: // Functions from base classes

	/**
    * From CCoeControl,Draw.
    */
    void Draw(const TRect& aRect) const;
    
	/**
    * From CoeControl,SizeChanged.
    */
    void SizeChanged();
    
	/**
    * From CoeControl,CountComponentControls.
    */        
   	TInt CountComponentControls() const;
   	
	/**
    * From CCoeControl,ComponentControl.
    */
	CCoeControl* ComponentControl(TInt aIndex) const;
	
	/**
    * From CCoeControl,OfferKeyEventL.
    */
	TKeyResponse OfferKeyEventL( const TKeyEvent& aKeyEvent, TEventCode aType );
	
	/**
    * From MEikListBoxObserver,OfferKeyEventL.
    */
	void HandleListBoxEventL(CEikListBox* aListBox,
							 TListBoxEvent aListBoxEvent);
	
	/**
	* From MTransactionObserver. Called when a GPRS connection is opened.
	*/
	void OpeningConnectionL();
							 
	/**
	* From MTransactionObserver. Called when a transaction is initiated.
	* @param aLoadingTasks ETrue if loading tasks, EFalse if completing a task.
	*/
	void ConnectingToServerL(const TBool& aLoadingTasks);
	
	/**
	* From MTransactionObserver. Called when a transaction is 
	* successfully completed. Note that this indicates a success only in 
	* the transaction. Errors may have occurred in the database and 
	* these errors are notified in the aData variable.
	* @param aResponse the response that was received from the server.
	*/
	void SuccessL(const CResponse& aResponse);
	
	/**
	* From MTransactionObserver. Called when a transaction has failed.
	* @param aError the error code
	*/
	void FailedL(const TInt& aError);
	
	/**
	* From MTransactionObserver. Called when user cancelled the transaction.
	*/
	void CancelledL();
	
	/**
	* From MTransactionObserver. Called if the connection settings are invalid 
	* and the socket connection cannot be initiated.
	* @param aErrorMsg the reason why the socket connection cannot be initiated.
	*/
	void ErrorL(const TDesC& aErrorMsg);
	
private:

	/**
	* Symbian OS Default constructor.
	*/
	void ConstructL(const TRect& aRect);
    CTaskManagerAppView(CTaskManagerAppUi& aAppUi);
    
private: // New functions

	/**
	* Reads tasks from aResponse and adds them to the listbox.
	* @param aResponse holds the tasks.
	*/
	void ReadTasksL( const CResponse& aResponse );
    
    /**
    * Shows a proper status text to the user. Status text is defined for the following 
    * states: loading tasks, completing tasks, no tasks. If state is not any of the these, 
    * a list of tasks is shown to the user.
    * @param aStatus the text that is to be shown to the user. 
    */
    void ShowStatus(const TDesC& aStatus);
    
    /**
    * Creates a listbox that is used for showing the tasks.
    */
    void CreateListL();

	/**
	* Removes the selected task from the listbox.
	*/
	void DeleteSelectedTaskL();    
    
	enum TTransactionStatus
		{
		EFetchingTasks = 0,
		EMarkingTaskDone
		};
    
private: // Data members
    
    CAknSingleStyleListBox* iTaskList;
    CTaskManagerAppUi& iAppUi;
    TTransactionStatus iTransactionStatus;
    TBuf<KMaxStatusTextLength> iStatusText;
	};


#endif // __TASKMANAGER_APPVIEW_H__

// End of file
