#ifndef TASKMANAGERENGINEWRITER_H
#define TASKMANAGERENGINEWRITER_H

#include <in_sock.h>

class CTaskManagerEngineWriter : public CActive
{
public: // new methods

	static CTaskManagerEngineWriter* NewL( RSocket& aSocket );
	
	static CTaskManagerEngineWriter* NewLC( RSocket& aSocket );

	~CTaskManagerEngineWriter();
	
	void DoWriteL( const TDesC& aData );
	
protected: // from CActive

	void DoCancel();
	
	void RunL();
	
private: // private methods
	
	CTaskManagerEngineWriter( RSocket& aSocket );
	
	void ConstructL();
	
	void SendNextPacket();
	
private: // member variables

	enum 
	{
		KWriteBufferSize = 20
	};
	
	enum TWriterState
	{
		EWaiting = 0,
		ESending
	};

	RSocket& iSocket;
	
	// data waiting to be sent
	TBuf8<KWriteBufferSize> iTransferBuffer;

	// data being written to socket
	TBuf8<KWriteBufferSize> iWriteBuffer;
	
	TWriterState iState;
};

#endif