/*
* ============================================================================
*  Name     : CTaskManagerApp from TaskManagerApp.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#ifdef __SERIES60_30__
#include 	<eikstart.h>
#endif

#include    "TaskManagerApp.h"
#include    "TaskManagerDocument.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CTaskManagerApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CTaskManagerApp::AppDllUid() const
    {
    return KUidTaskManagerApp;
    }

   
// ---------------------------------------------------------
// CTaskManagerApp::CreateDocumentL()
// Creates CTaskManagerDocument object
// ---------------------------------------------------------
//
CApaDocument* CTaskManagerApp::CreateDocumentL()
    {
    return CTaskManagerDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication() 
// Constructs CTaskManagerApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return new CTaskManagerApp;
    }

// ---------------------------------------------------------
// Entry point function for Symbian Apps, separate function for
// S60 3rd Ed and 1st/2nd Ed
// ---------------------------------------------------------
//
#ifdef __SERIES60_30__
GLDEF_C TInt E32Main()
	{
	return EikStart::RunApplication( NewApplication );
	}

#else
GLDEF_C TInt E32Dll( TDllReason )
	{
	return KErrNone;
	}
#endif
// End of File  

