/*
* ============================================================================
*  Name     : CRequest from Request.cpp
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#include "Request.h"
#include "TaskManager.pan"

// CONSTANTS
_LIT(KTab, "\t");
_LIT(KLineEnd, "\n");
_LIT(KSeparator, "#");

_LIT(KFetchCommand, "fetch");
_LIT(KMarkCommand, "mark");

_LIT(KUnknownOperation, "Unknown operation!");

// ================= MEMBER FUNCTIONS =======================

// ----------------------------------------------------
// CRequest::GetMessage()
// Static parser function that returns a descriptor containing
// a client message that the server end understands.
// ----------------------------------------------------
//	
void TRequest::GetMessage( TDesC& aUsername, TDesC& aPassword,
	                       TRequest::TOperationType aOperation,
	                       TDesC& aId, TDes8& aMessage )
    {
	// A valid command string is built
	// Format: username#password#operation[#id]
    aMessage.Zero();
    
	aMessage.Append( aUsername );
	aMessage.Append( KSeparator );
	aMessage.Append( aPassword );
	aMessage.Append( KSeparator );

	switch( aOperation )
	{
		case TRequest::EFetchTasks:
		{
			aMessage.Append( KFetchCommand );
			break;
		}
		case TRequest::ETaskDone:
		{
			aMessage.Append( KMarkCommand );
			aMessage.Append( KSeparator );
    		aMessage.Append( aId );
			break;
		}
		default:
		{
			User::Panic( KUnknownOperation, ETaskManagerInvalidTask );
		}
	}
	
	aMessage.Append( KLineEnd );
    }

// End of file