/*
* ============================================================================
*  Name     : CResponse from Response.h
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __CRESPONSE_H
#define __CRESPONSE_H

// INCLUDE FILES
#include "TaskManager.hrh"

#include <e32std.h>
#include <badesca.h>            //CDesCArray

// CLASS DECLARATION

/**
* A wrapper class for handling responses from the server.
*/
class CResponse : public CBase
	{
public: // Constructors and destructor

    /**
    * Enum for following the class' state.
    */
    enum TResponseState
        {
        ENotComplete,
        EComplete,
        EError
        };
	
	/**
	* Two-phased constructor.
	*/
	static CResponse* NewL();

	/**
	* Two-phased constructor.
	*/
	static CResponse* NewLC();

	/**
	* Destructor
	*/
	~CResponse();

    /**
    * Determines what type of response is in question.
    */
	enum TResponseType
		{
		ELoadTasks = 0,
		ETaskComplete
		};

public: // New functions

	/**
	* Constructs this response object from the data received from the server.
	* @param aData the data that was received from the server
	*/
	void ParseDataL( TDesC& aData );
    
	/**
	* Returns whether errors occurred in the server side.
	* @return ETrue if response consist errors, EFalse if not.
	*/
	TBool HasError() const;

	/**
	* Returns the error description.
	* @return the error description.
	*/
	TBuf<KMaxError> Error() const;

	/**
	* Returns the number of tasks received from the server.
	* @return the number of tasks received from the server.
	*/
	TInt TaskCount() const;

	/**
	* Returns the task description.
	* @param aIndex the index of the description.
	* @return the task description.
	*/
	TBuf<KMaxTaskLength> TaskDescription(const TInt& aIndex) const;

	/**
	* Returns the task id.
	* @return the task id.
	*/
	TInt TaskId(const TInt& aIndex) const;

	/**
	* Returns the type of this response. 
	* @return the type of this response.
	*/
	TResponseType ResponseType() const;

    /**
    * Takes in a part of the server message.
    * @param aData part of the message
    */
    void InputDataL( const TDesC8& aData );
    
    /**
    * Returns whether the entire message has been given to CResponse. This
    * function is used specifically by the engine to determine whether or not
    * continue reading from the socket.
    * @return ETrue if message is complete, EFalse if not.
    */
    TResponseState GetState() const;

private: 

    /**
    * This function checks if the already received data forms a valid
    * message, e.g. it is of right size and data is legal.
    */
    void DoCheck();

	/**
	* Symbian OS default constructor
	*/
	CResponse();
	void ConstructL();
	
	/**
	* Message parser state machine states.
	*/
	enum TTaskReadStatus
		{
		EStart = 0,
		EReadId,
		EReadTask
		};

private: // Data members

    // Error informers
	TBuf<KMaxError>	iError;
	
	CDesCArray*		iDescriptions;
	RArray<TInt>	iIds;
	TResponseType	iResponseType;
	
	// Resizable descriptor for storing the message
	HBufC*          iMessageBuffer;
	
	TInt            iExpectedPackageSize;
	TResponseState  iState;
	};

#endif

// End of file