/*
* ============================================================================
*  Name     : taskmanager.pan
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Description:
*     This file contains thread panics.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __TASKMANAGER_PAN__
#define __TASKMANAGER_PAN__

#include <e32std.h>

enum TTaskManagerPanics 
{
    ETaskManagerBasicUi = 1,
    ETaskManagerServerAddressTooLong,
    ETaskManagerUsernameTooLong,
    ETaskManagerPasswordTooLong,
    ETaskManagerInvalidTaskIndex,
    ETaskManagerInvalidTask,
    ETaskManagerInvalidState
};

inline void Panic(TTaskManagerPanics aReason)
{
	_LIT(applicationName,"SocketTaskManager");
    User::Panic(applicationName, aReason);
}

inline void Panic(TInt aPanicCode)
	{
	_LIT(KApplicationName, "SocketTaskManager");
	User::Panic(KApplicationName, aPanicCode);
	}

inline void PanicIfError(TInt aPanicCode)
	{
	if (aPanicCode != KErrNone)
		{
		Panic(aPanicCode);
		}
	}

#endif // __TaskManager_PAN__
