/*
* ============================================================================
*  Name     : CTaskManagerAppView from TaskManagerAppView.h
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __TASKMANAGER_APPVIEW_H__
#define __TASKMANAGER_APPVIEW_H__

// INCLUDE FILES
#include <eikbctrl.h> // CEikBorderedControl
#include "TaskManagerEngine.h"

// CONSTANTS
const TInt KMaxStatusTextLength = 25;

// FORWARD DECLARATIONS
class CTaskManagerAppUi;
class CEikColumnListBox;

// CLASS DECLARATION

/**
* A container class that shows tasks to user and responds to notifications.
*
*/
class CTaskManagerAppView : public CEikBorderedControl, 
							public MTransactionObserver
	{
public: // Constructors and destructor

	/**
	* Two-phased constructor.
	*/
	static CTaskManagerAppView* NewL(const TRect& aRect, CTaskManagerAppUi& aAppUi);

	/**
	* Destructor.
	*/
     ~CTaskManagerAppView();


public: // New functions

	/**
	* Shows a list of IAPs to user for choosing the one to be used.
	* @param aId id of the IAP that the user chose.
	* @param aDefaultId IAP with this id is highlighted in the list query.
	* @return ETrue if user chose an IAP, EFalse if not.
	*/
	TBool QueryIapL(TUint32& aId, const TUint32& aDefaultId);
	
	/**
	* Will mark the currently selected task as completed in the server.
	*/
	void CompleteTaskL();

private: // Functions from base classes

	/**
    * From CCoeControl,Draw.
    */
    void Draw(const TRect& aRect) const;
    
	/**
    * From CoeControl,SizeChanged.
    */
    void SizeChanged();
    
	/**
    * From CoeControl,CountComponentControls.
    */        
   	TInt CountComponentControls() const;
   	
	/**
    * From CCoeControl,ComponentControl.
    */
	CCoeControl* ComponentControl(TInt aIndex) const;
	
	/**
    * From CCoeControl,OfferKeyEventL.
    */
	TKeyResponse OfferKeyEventL( const TKeyEvent& aKeyEvent, TEventCode aType );
	
	
	/**
	* From MTransactionObserver. Called when a GPRS connection is opened.
	*/
	void OpeningConnectionL();
							 
	/**
	* From MTransactionObserver. Called when a transaction is initiated.
	*/
	void ConnectingToServerL(const TBool& aLoadingTasks);
	
	/**
	* From MTransactionObserver. Called when a transaction is 
	* successfully completed. Note that this indicates a success only in 
	* the transaction. Errors may have occurred in the database and 
	* these errors are notified in the aResponse variable.
	* @param aResponse the data that was received by the transaction.
	*/
	void SuccessL(const CResponse& aResponse);
	
	/**
	* From MTransactionObserver. Called when a transaction failed.
	* @paran aError the error code
	*/
	void FailedL(const TInt& aError);
	
	/**
	* From MTransactionObserver. Called when user cancelled a transaction.
	*/
	void CancelledL();
	
	/**
	* From MTransactionObserver. Called if the connection settings are invalid 
	* and the connection cannot be initiated.
	* @paran aErrorMsg the reason why the connection cannot be initiated.
	*/
	void ErrorL(const TDesC& aErrorMsg);
	
private:

	/**
	* Symbian OS Default constructor.
	*/
	void ConstructL(const TRect& aRect);
    CTaskManagerAppView(CTaskManagerAppUi& aAppUi);
    
private: // New functions

	/**
	* Reads tasks from aResponse and adds them to the listbox.
	* @param aResponse holds the tasks.
	*/
	void ReadTasksL( const CResponse& aResponse );
    
    /**
    * Shows a proper status text to the user. Status text is defined for the following 
    * states: loading tasks, completing tasks, no tasks. If state is not any of the these, 
    * a list of tasks is shown to the user.
    * @param aStatus the text that is to be shown to the user. 
    */
    void ShowStatus(const TDesC& aStatus);
    
    /**
    * Creates a listbox that is used for showing the tasks.
    */
    void CreateListL();

	/**
	* Removes the selected task from the listbox.
	*/
	void DeleteSelectedTaskL();    
    
	enum TTransactionStatus
		{
		EFetchingTasks = 0,
		EMarkingTaskDone
		};
    
private: // Data members
    
    CEikColumnListBox* iTaskList;
    CTaskManagerAppUi& iAppUi;
    TTransactionStatus iTransactionStatus;
    TBuf<KMaxStatusTextLength> iStatusText;
	};


#endif // __TASKMANAGER_APPVIEW_H__

// End of file
