/*
* ============================================================================
*  Name     : CTaskManagerConnForm from TaskManagerConnForm.h
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef TASKMANAGERCONNFORM_H
#define TASKMANAGERCONNFORM_H

// INCLUDE FILES
#include <eikdialg.h>
#include <e32base.h>

// FORWARD DECLARATIONS
class TTaskManagerConnInfo;

// CLASS DECLARATION

/**
* A form class for querying the connection settings from the user.
*
*/
class CTaskManagerConnForm : public CEikDialog
	{
public: // New functions

	/**
	* Runs and destroys the form.
	* @param aConnInfo is where the connections setting defined by the user are set.
	* @return ETrue if OK was pressed, EFalse if not.
	*/
	static TBool RunDlgLD( TTaskManagerConnInfo& aConnInfo );
	
private: // Functions from base classes

	/**
	* From CAknForm, OkToExitL.
	*/
	TBool OkToExitL( TInt aButtonId );
	
	/**
	* From CEikDialog, PreLayoutDynInitL.
	*/
	void PreLayoutDynInitL();

private:
	
	/**
	* Symbian OS Default constructor.
	*/
	CTaskManagerConnForm( TTaskManagerConnInfo& aConnInfo );

private: // Data members

	TTaskManagerConnInfo& iConnInfo;
	
	};
	

#endif

// End of file