/*
* ============================================================================
*  Name     : CTaskManagerEngineReader from TaskManagerEngineReader.h
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __TASKMANAGERENGINEREADER_H__
#define __TASKMANAGERENGINEREADER_H__

#include <in_sock.h>

class CSecureSocket;

// CLASS DECLARATIONS

/**
* A mixin for notifying about received packages
*/
class MEngineNotifier
    {
public:
    virtual TBool PackageReceivedL( const TDesC8& aData ) = 0;
    };


/**
* A socket reader class.
* Is used for reading data from a socket and informing an observer.
*/
class CTaskManagerEngineReader : public CActive
    {
public:

    /**
    * Two-phased constructor.
    */
	static CTaskManagerEngineReader* NewL( MEngineNotifier& aNotifier );
    static CTaskManagerEngineReader* NewLC( MEngineNotifier& aNotifier );

    /**
    * Destructor
    */
	~CTaskManagerEngineReader();

    /**
    * Initiate a read from socket.
    */
	void Start();
	
    /**
    * Sets a secure socket.
    * @param aSocket The secure socket from which to read.
    */	
    void SetSecureSocket( CSecureSocket* aSocket );

protected: // from CActive

    /**
    * Cancel any pending operation
    */
	void DoCancel();

    /**
    * Called when operation complete
    */
	void RunL();	

private:

    /**
    * Perform the first phase of two-phase construction.
    * @param aNotifier Handle to notify the engine.
    */
	CTaskManagerEngineReader( MEngineNotifier& aNotifier );

    /**
    * Perform the second phase construction of a CSocketsReader.
    */
	void ConstructL();

    /**
    * Initiate a read from socket.
    */
	void IssueRead();

private: // Member variables

    // The size of the read buffer in bytes.
    enum { KReadBufferSize = 20 };

    // Socket to read data from.
    CSecureSocket*          iSocket;

    // Buffer for receiving data.
	TBuf8<KReadBufferSize>  iBuffer;

    // Handle to notify engine.
    MEngineNotifier&        iNotifier;
    
    // Stores the amount of bytes read from socket.
    // Must be defined even though it's not used anywhere except when reading.
    TSockXfrLength          iDummyLength;
    };

#endif

// End of file