/*
* ============================================================================
*  Name     : CTaskManagerApp from TaskManagerApp.h
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#include    "TaskManagerApp.h"
#include    "TaskManagerDocument.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CTaskManagerApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CTaskManagerApp::AppDllUid() const
    {
    return KUidTaskManagerApp;
    }

   
// ---------------------------------------------------------
// CTaskManagerApp::CreateDocumentL()
// Creates CTaskManagerDocument object
// ---------------------------------------------------------
//
CApaDocument* CTaskManagerApp::CreateDocumentL()
    {
    return CTaskManagerDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication() 
// Constructs CTaskManagerApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return new CTaskManagerApp;
    }

// ---------------------------------------------------------
// E32Dll(TDllReason) 
// Entry point function for Symbian Apps
// Returns: KErrNone: No error
// ---------------------------------------------------------
//
GLDEF_C TInt E32Dll( TDllReason )
    {
    return KErrNone;
    }

// End of File  

