/*
* ============================================================================
*  Name     : TTaskManagerConnInfo from TaskManagerConnInfo.cpp
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#include "TaskManagerConnInfo.h"
#include "TaskManager.pan"

// CONSTANTS
const TInt TTaskManagerConnInfo::KDefaultPort = 3000;

// ================= MEMBER FUNCTIONS =======================

// constructor
TTaskManagerConnInfo::TTaskManagerConnInfo(): iPort( KDefaultPort ), iIap(0)
	{
	// No implementation
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::SetServerAddress()
// Sets the server address.
// ----------------------------------------------------------
//
void TTaskManagerConnInfo::SetServerAddress( const TDesC& aAddress )
	{
	if( aAddress.Length() > KMaxServerNameLength )
		{
		Panic(ETaskManagerServerAddressTooLong);
		}
	iServerAddress.Copy( aAddress );
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::ServerAddress()
// Gets the server address.
// ----------------------------------------------------------
//
TBufC< KMaxServerNameLength > TTaskManagerConnInfo::ServerAddress() const
	{
	return iServerAddress;
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::SetPort()
// Sets the port number.
// ----------------------------------------------------------
//	
void TTaskManagerConnInfo::SetPort( const TInt aPort )
	{
	iPort = aPort;
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::Port()
// Gets the port number.
// ----------------------------------------------------------
//	
const TInt TTaskManagerConnInfo::Port() const
	{
	return iPort;
	}
	
// ----------------------------------------------------------
// TTaskManagerConnInfo::SetUsername()
// Sets the username.
// ----------------------------------------------------------
//		
void TTaskManagerConnInfo::SetUsername( const TDesC& aUsername )
	{
	if( aUsername.Length() > KMaxUsernameLength )
		{
		Panic(ETaskManagerUsernameTooLong); 
		}
	iUsername.Copy( aUsername );
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::Username()
// Gets the username.
// ----------------------------------------------------------
//		
TBufC< KMaxUsernameLength > TTaskManagerConnInfo::Username() const
	{
	return iUsername;	
	}
	
// ----------------------------------------------------------
// TTaskManagerConnInfo::SetPassword()
// Sets the password.
// ----------------------------------------------------------
//			
void TTaskManagerConnInfo::SetPassword( const TDesC& aPassword )
	{
	if( aPassword.Length() > KMaxPasswordLength )
		{
		Panic(ETaskManagerPasswordTooLong);
		}
	iPassword.Copy( aPassword );
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::Password()
// Gets the password.
// ----------------------------------------------------------
//		
TBufC< KMaxPasswordLength > TTaskManagerConnInfo::Password() const
	{
	return iPassword;	
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::SetIap()
// Sets the IAP.
// ----------------------------------------------------------
//			
void TTaskManagerConnInfo::SetIap( const TUint32& aId)
	{
	iIap = aId;
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::Iap()
// Gets the IAP.
// ----------------------------------------------------------
//			
TUint32 TTaskManagerConnInfo::Iap() const
	{
	return iIap;
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::ExternalizeL()
// Saves the connection data to the given stream.
// ----------------------------------------------------------
//		
void TTaskManagerConnInfo::ExternalizeL(RWriteStream& aStream) const
	{
	aStream << iServerAddress;
	aStream.WriteInt32L(iPort);
	aStream << iUsername;
	aStream << iIap;
	}

// ----------------------------------------------------------
// TTaskManagerConnInfo::InternalizeL()
// Reads the connections data from the given stream.
// ----------------------------------------------------------
//			
void TTaskManagerConnInfo::InternalizeL(RReadStream& aStream)
	{
	aStream >> iServerAddress;
	iPort  = aStream.ReadInt32L();
	aStream >> iUsername;
	aStream >> iIap;
	}
	
// End of file