/*
* ============================================================================
*  Name     : CTaskManagerIapDialog from TaskManagerIapDialog.cpp
*  Part of  : TaskManager
*  Created  : 08/31/2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#include "TaskManagerIapDialog.h"
#include <eiktxlbx.h> // CEikTextListBox
#include <eiktxlbm.h> // CTextListBoxModel
#include "taskmanager.hrh"

// ================= MEMBER FUNCTIONS =======================

// constructor
CTaskManagerIapDialog::CTaskManagerIapDialog(CDesCArray& aIaps, TInt& aSelectedIap)
	:	iIaps(aIaps),
		iSelectedIap(aSelectedIap)
	{
	
	}

// destructor	
CTaskManagerIapDialog::~CTaskManagerIapDialog()
	{	
	}
	
// ----------------------------------------------------
// CTaskManagerIapDialog::PreLayoutDynInitL()
// This function is called by the dialog framework 
// before the dialog is sized and laid out.
// ----------------------------------------------------
//		
void CTaskManagerIapDialog::PreLayoutDynInitL()
	{
    CEikTextListBox* listbox = static_cast<CEikTextListBox*>(ControlOrNull(ETaskManagerIapListbox));
    User::LeaveIfNull(listbox);
	listbox->Model()->SetItemTextArray(&iIaps);
	listbox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	listbox->SetCurrentItemIndex(iSelectedIap);
	}

// ----------------------------------------------------
// CTaskManagerIapDialog::PreLayoutDynInitL()
// Handles a dialog button press for the specified button.
// ----------------------------------------------------
//	
TBool CTaskManagerIapDialog::OkToExitL(TInt aKey)
	{
	if (aKey == EEikBidOk)
		{
	    CEikTextListBox* listbox = static_cast<CEikTextListBox*>(ControlOrNull(ETaskManagerIapListbox));
    	User::LeaveIfNull(listbox);
		iSelectedIap = listbox->CurrentItemIndex();
		}

	return ETrue;
	}
	
// End of file