/*
 * Copyright 2005 Nokia. All rights reserved.
 */
package com.forum.nokia.taskmanager;

/**
 * A structure to store a single task.
 * 
 */
public class Task
{
    private int id;
    private String description;
    
    /**
     * Basic constructor.
     * 
     * @param id Id of the task.
     * @param description Description of the task.
     */
    public Task( int id, String description )
    {
        this.id = id;
        this.description = description;
    }
    
    /**
     * Getter for task id.
     * @return Id of the task as integer.
     */
    public int getId() { return id; }
    
    /**
     * Getter for task description.
     * @return Description of the task as string.
     */
    public String getDesc() { return description; }
}
