/*
 * Copyright 2005 Nokia. All rights reserved.
 */
package com.forum.nokia.taskmanager.comm;

import java.io.*;
import javax.net.ssl.*;

/**
 * This class is the programs main class. It instantiates a new thread to handle
 * an incoming connection.
 *  
 */
public class TaskManagerServer
{
    /**
     * The port in which the server listens to inbound connections.
     */
    private static final int PORT = 33221;
    
    /**
     * Server entry-point, instantiates a new thread to handle the connection. 
     * 
     * @param args Command-line arguments, not used.
     * @throws IOException
     */
    public static void main(String[] args) throws IOException
    {
        SSLServerSocketFactory factory = (SSLServerSocketFactory) 
                                               SSLServerSocketFactory.getDefault();
        SSLServerSocket serverSocket = (SSLServerSocket)
         									   factory.createServerSocket( PORT );
        
        while( true )
        {
            new TaskManagerServerThread( (SSLSocket)
                    serverSocket.accept() ).start();
        }
    }
}
