/*
 * Copyright 2005 Nokia. All rights reserved.
 */
package com.forum.nokia.taskmanager.comm;

import javax.net.ssl.*;
import java.io.*;

import com.forum.nokia.taskmanager.*;
import com.forum.nokia.taskmanager.database.*;

/**
 * This class represents a single thread that is started when the client
 * connects to the server. Since there's a separate thread for each connection,
 * synchronization is not a problem.
 *  
 */
public class TaskManagerServerThread extends Thread
{
    // !!! CHANGE THESE ACCORDING TO YOUR SERVER SETUP
    
    // Server URI in the following format:
    // "jdbc:mysql://servername.com/databasename"
    // e.g. "jdbc:mysql://nokia.com/taskdb (taskdb is the default database name)
    private static final String SERVER_URI = "jdbc:mysql://xyz.com/taskdb";
    // mysql server username (user taskdb is created by default)
    private static final String USERNAME = "taskman";
    // mysql user password
    private static final String PASSWORD = "";
    
    private SSLSocket socket = null;
    
    /**
     * Standard constructor, calls the superclass.
     * 
     * @param socket The ssl-socket that was opened. 
     */
    public TaskManagerServerThread( SSLSocket socket )
    {
        super( "TaskManagerServerThread" );
        this.socket = socket;
    }
    
    /**
     * This function is executed when the class TaskManagerServer calls this
     * class' start() method (inherited from Thread).
     */
    public void run()
    {
       System.out.println( "connection opened" );
       
       // Database communicator is instantiated.
       DBCommunicator dbc = null;
       try
       {
           dbc = new DBCommunicator( SERVER_URI, USERNAME, PASSWORD );
       }
       catch( Exception e )
       {
           // If we couldn't open a connection to the MySQL-server,
           try
           {
               // connection is closed
               socket.close();
           }
           catch( IOException ioe )
           {
               ioe.printStackTrace();
           }
           return;
       }
       
       PrintWriter out = null;
       BufferedReader in = null;
       try {
           out = new PrintWriter( socket.getOutputStream(), true );
           in = new BufferedReader(
    	            				new InputStreamReader(
    	            				        socket.getInputStream() ) );

    	    
    	    
    	    String inputLine, outputLine = "";

            // This loop runs until the connection is closed or an errorenous
            // package is received.
    	    while( (inputLine = in.readLine()) != null )
    	    {
    	        System.out.println( inputLine ); // For debug purposes
		
    	        try
    	        {
                    // A new ClientPackage is created from the client message.
    	            ClientPackage cp = new ClientPackage( inputLine );
                    System.out.println("Input ok");
                    
                    // The client request is processed and turned into a response.
                    String output = dbc.processClientPackage( cp ).getMessage();
                    System.out.println( output ); // For debug purposes
                    
                    // The response is sent back to the client.
                    out.println( output );
                    System.out.println( "Package sent" );
    	        }
    	        catch( IllegalArgumentException e )
    	        { // client message was errorenous
    	            out.println( "Error: " + e.getMessage() );
    	            break;
    	        }
    	    }
    	    System.out.println("connection closed\n");
    	}
    	catch (IOException e)
    	{
    	    e.printStackTrace();
    	}
        finally
        {
            // Close the streams and the socket.
            out.close();
            try
            {
                in.close();
                socket.close();
            }
            catch( IOException e )
            {
                e.printStackTrace();
            }
            
            // Close the database connection opened by DBCommunicator
            dbc.closeDBConnection();
        }
    }
}