// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Defines RSecureSession and RSecureSubSession classes.
//



/**
 @file
*/
#ifndef __SECURECLIENT_H__
#define __SECURECLIENT_H__

#include <e32base.h>

/**
The client-side handle to a session with the server.
The class forms a layer over the Symbian provided RSessionBase class.
The main example code calls member functions in the subsession class to make requests to the server. The subsession forwards the requests to the server through the session.
A request is identified by a number. This is one of the TSecureServerRequest enum values defined in secureclientandserver.h, The session passes the number and any arguments to the server in a TIpcArgs object.
@see RSecureSubSession
*/
class RSecureSession : public RSessionBase
	{
public:
	RSecureSession();
	TInt Connect();
	TVersion Version() const;
	TInt ResourceCountL();
	void Close();
private:
	RThread iServerThread;
	};

/**
The client-side handle to a subsession with the server.
The class forms a layer over the Symbian provided RSubSessionBase class.
The main example code calls member functions in this class to make requests to the server. The class forwards the requests to the server through the session.
@see RSecureSession
*/
class RSecureSubSession : public RSubSessionBase
	{
public:
	TInt Open(RSecureSession& aServer);
	TInt SetFromString(const TDesC& aString);
	void Close();
	void Increase();
	void Decrease();
	void IncreaseByL(TInt anInt);
	void DecreaseByL(TInt anInt);
	void Reset();
	TInt CounterValueL();
	void VerifyTransaction();
	void SaveCounterL();
	void SetCounterFromFileL();
	};

#endif

