// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Defines enums and constants that are common to the client and the server.
// The most important items are:
// - the enum TSecureServerRequest that defines requests. These request numbers are also known as op codes.
// - the numbers that define the version of the server and the version of the server that the client requires.
//



/**
 @file
 @see RSecureSubSession
*/

#ifndef __SECURECLIENTANDSERVER_H__
#define __SECURECLIENTANDSERVER_H__

#include <e32base.h>
#include <e32cons.h>

/**
 Name of the server.
 */
_LIT(KSecureServerName,"SecureServer");

const TUint KDefaultMessageSlots=4;

/**
Version numbers of the server.
*/
const TUint KSecureServMajorVersionNumber = 0;
const TUint KSecureServMinorVersionNumber = 1;
const TUint KSecureServBuildVersionNumber = 1;

IMPORT_C TInt StartThread(RThread& aServerThread);

/**
Op codes supported by the server.
 */
enum TSecureServerRequest
	{
	/**
	Op code to create a subsession.
	*/
	ESecureServerCreateSubSession,
	/**
	Op code to close a subsession.
	*/
	ESecureServerCloseSubSession,
	/**
	Op code to initialise the counter of the subsession.
	*/
	ESecureServerInitSubSession,
	/**
	Op code to close a session.
	*/
	ESecureServerCloseSession,
	/**
	Op code to get the counter value from the server.
	*/
	ESecureServerValue,
	/**
	Op code to get the resource count from the server.
	*/
	ESecureServerResourceCount,
	/**
	Op code to increase the counter value by one.
	*/
	ESecureServerIncrease,
	/**
	Op code to increase the counter value by a value greater than one.
	*/
	ESecureServerIncreaseBy,
	/**
	Op code to decrease the counter value by one.
	*/
	ESecureServerDecrease,
	/**
	Op code to increase the counter value by a value greater than one.
	*/
	ESecureServerDecreaseBy,
	/**
	Op code to reset the counter to default value.
	*/
	ESecureServerReset,
	/**
	Op code to save the counter value to the counter.dat file.
	*/
	ESecureServerSaveCounter,
	/**
	Op code to set the counter value from the counter.dat file.
	*/
	ESecureServerSetCounterFromFile
	};

/**
Defines the leave code of the server.
*/
enum TSecureServerLeave
	{
	/**
	Leave code if the string that sets the counter contains  non-numeric characters.
	For example, the string "ab" is invalid and "10" is valid.
	@see CSecureServerSubSession::SetFromStringL
	*/
	ENonNumericString = 99
	};

_LIT(KTextConsoleTitle, "Secure Server Console");
_LIT(KTextFailed, " failed, leave code = %d");
_LIT(KTextPressAnyKey, " [press any key]\n");

_LIT(KTxtTestingCountServer,"Testing the count server test with 2 client sub sessions; these represent independent counters \n\n");
_LIT(KTxtInitCounterAWith,"\nInitialize counter A with : ");
_LIT(KTxtInitCounterBWith,"\nInitialize counter B with : ");
_LIT(KTxtInitCounterFailed,"\nSetting the counter from string failed: non-numeric character detected\n");
_LIT(KTxtInitCounterSucceeded,"\nSetting the counter from string succeeded\n");
_LIT(KTxtGetCounterAValue,"Getting counterA value from server: %d \n");
_LIT(KTxtGetCounterBValue,"Getting counterB value from server: %d \n");
_LIT(KTxtTransactionId,"***\nTransaction ID of the session : %d\n***\n");
_LIT(KMsgPressAnyKey," (press any key to continue)\n");
_LIT(KTxtOption,"\nEnter 1 to initialise from file\n");
_LIT(KTxtInitFromFile,"\nInitialising from file, value = %d\n");
_LIT(KTxtTransactionID,"\nEnter the Transaction ID for the session\n");
_LIT(KTxtSaveToFile,"\nTo save the value of counter A press 'a' and for counter B press 'b'..\n");
_LIT(KTxtSelectCounter,"\nYou selected counter %c\n");
_LIT(KTxtSaveCounter,"\nSaving Counter Value..\n");

#endif
