// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the implementation of functions described in the CSecureServer class.
//



/**
 @file
*/
#include "secureclientandserver.h"
#include "secureserver.h"

/**
The thread function that makes the server ready for use.
The Symbian platform calls the function when the server thread starts to run.
This is a static function, and it
- creates the server object
- creates the servers active scheduler
- starts the servers active scheduler
@return KErrNone.
*/
TInt CSecureServer::ThreadFunction(TAny* /**aStarted*/)
	{
	TInt err;
	CTrapCleanup* cleanup = CTrapCleanup::New();
	if (cleanup == NULL)
		{
		PanicServer(ECreateTrapCleanup);
		}

	CActiveScheduler* pScheduler=new CActiveScheduler;
	__ASSERT_ALWAYS(pScheduler,PanicServer(EMainSchedulerError));
	CActiveScheduler::Install(pScheduler);

	CSecureServer* pServer = NULL;
	TRAP(err,pServer = CSecureServer::NewL(EPriorityStandard));
	__ASSERT_ALWAYS(!err,CSecureServer::PanicServer(EServerCreateServer));

	err = pServer->Start(KSecureServerName);
	if (err != KErrNone)
		{
		CSecureServer::PanicServer(EServerStartServer);
		}

	RThread::Rendezvous(KErrNone);
	CActiveScheduler::Start();

	delete pServer;
	delete pScheduler;
	delete cleanup;

	return KErrNone;
	}

/**
Creates the server thread.
If the server is not running, the function starts the server thread. The function CSecureServer::ThreadFunction() contains the code that is called when the server thread starts.
@param aServerThread The handle to the server thread.
@return KErrNone if successful, or an error code returned by RThread::Create().
@see CSecureServer::ThreadFunction()
*/
EXPORT_C TInt StartThread(RThread& aServerThread)
	{
	TInt res=KErrNone;
	TFindServer findCountServer(KSecureServerName);
	TFullName   name;
	if (findCountServer.Next(name)!=KErrNone)
		{
			res=aServerThread.Create(KSecureServerName,
			CSecureServer::ThreadFunction,
			KDefaultStackSize,
			KDefaultHeapSize,
			KDefaultHeapSize,
			NULL
			);
		if (res==KErrNone)
			{
			TRequestStatus rendezvousStatus;
			aServerThread.SetPriority(EPriorityNormal);
			aServerThread.Rendezvous(rendezvousStatus);
			aServerThread.Resume();
			User::WaitForRequest(rendezvousStatus);
			}
		else
			{
			aServerThread.Close();
			}
		}
	return res;
	}
