// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Demonstrates the pure event distribution pattern of publishing an integer property
//



/**
 @file
*/

#include "publishpe.h"

LOCAL_D CConsoleBase* console;

void DoExampleL()
	{
	console->Printf(KTxtPEPublish);
	RProperty myProperty;

	// Define the property and create a handle to it
	User::LeaveIfError(RProperty::Define(KMyPropertyCat, KMyPropertyName,RProperty::EInt,KAllowAllPolicy,KAllowAllPolicy));
	User::LeaveIfError(myProperty.Attach(KMyPropertyCat,KMyPropertyName,EOwnerThread));

	// The value of the property
	TInt value;

	// Publish the property after every 3 seconds
	for(TInt ix = 0; ix <= KMax ; ix += 20)
		{
		User::After(KTimeInterval);
		// Publish random values
		// In the pure event pattern of publishing, the value of the property is insignificant
		// Multiple publishing is only to let the subscriber know that an event has occurred
		value = Math::Random();
		console->Printf(KTxtInt,value);
		User::LeaveIfError(myProperty.Set(value));
		}

	// Free the handle to the property
	myProperty.Close();

	// The publisher has finished so delete the property
	User::LeaveIfError(RProperty::Delete(KMyPropertyCat,KMyPropertyName));
	}

GLDEF_C TInt E32Main()
	{
	__UHEAP_MARK;
	CTrapCleanup* cleanup = CTrapCleanup::New();

	TRAPD(createError, console = Console::NewL(KTextConsoleTitle, TSize(KConsFullScreen,KConsFullScreen)));
	if (createError)
		return createError;

	TRAPD(mainError, DoExampleL());
	if (mainError)
		console->Printf(KTextFailed, mainError);
	console->Printf(KTextPressAnyKey);
	console->Getch();

	delete console;
	delete cleanup;
	__UHEAP_MARKEND;
	return KErrNone;
	}
