// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the CArrayPropertyWatch class
//



/**
 @file
*/

#ifndef __SUBSCRIBE_H__
#define __SUBSCRIBE_H__

#include "pubsub.h"

/**
Subscribes to a byte-array property using the active object framework
*/
class CArrayPropertyWatch : public CActive
{
	enum {EPriority=0};
public:
	static CArrayPropertyWatch* NewL(CConsoleBase* aConsole);
	void WatchL();
	void DefinePropertyL();
private:
	CArrayPropertyWatch();
	void ConstructL(CConsoleBase* aConsole);
	~CArrayPropertyWatch();
	void RunL();
	void DoCancel();
	void PrintProperty(TDes16& aBuf);
private:
	// A handle to the subscribed property
	RProperty iProperty;
	// The user console
	CConsoleBase* iConsole;
};
#endif
