// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the CIntPropertyWatch class
//



/**
 @file
*/

#ifndef __SUBSCRIBEPE_H__
#define __SUBSCRIBEPE_H__

#include "pubsub.h"

/**
Subscribes to an integer property using the active object framework
*/
class CIntPropertyWatch : public CActive
	{
	enum {EPriority=0};
public:
	static CIntPropertyWatch* NewL(CConsoleBase* aConsole);
	void WatchL();
	void IssueRequest();
private:
	CIntPropertyWatch();
	void ConstructL(CConsoleBase* aConsole);
	~CIntPropertyWatch();
	void RunL();
	void DoCancel();
	void PrintProperty(TInt aValue);
private:
	// A handle to the subscribed property
	RProperty iProperty;
	// The user console
	CConsoleBase* iConsole;
	};
#endif
