// fifochild.c
//
// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

/**
Waits for a key press
@return Character code of the key pressed
*/
char PressKey()
	{
	char ch;
	fflush(stdout);
	ch=getchar();
	return ch;
	}

/**
Reports any error with error number from error.h
@param msg Error message to be printed
@return The failure code
*/
int Error(char msg[])
	{
	printf("%s [Error NUMBER = %d]\n",msg,errno);
	PressKey();
	return EXIT_FAILURE;
	}

int main()
{
	/** Name of the FIFO file to be created*/
	char fifoFileName[] = "myfifofile";
	/** Open the FIFO file, child process writes data to this file
	and the parent process reads data from this file*/
	int fifoFd = open(fifoFileName,O_WRONLY);
	/** open() returns -1 on failure*/
	if(fifoFd == -1)
	{
		/** Failed to open the FIFO*/
		Error("\n*** child failure FIFO Open ***\n");
		return EXIT_FAILURE;
	}
	else
	{
		/** Create a message to send to the parent*/
		char TxMsg[] = "Hello Parent [FIFO]\n";
		/** Child process sends a message string to the parent*/
		write(fifoFd,TxMsg,sizeof(TxMsg));
		/** Close the FIFO*/
		(void)close(fifoFd);
	}
	return EXIT_SUCCESS;
}

