// ipcparent.c
//
// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

//

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <errno.h>
#include <spawn.h>
#include <string.h>
#include <sys/wait.h>

/**
Waits for a key press
@return Character code of the key pressed
*/
char PressKey()
	{
	char ch;
	fflush(stdout);
	ch=getchar();
	return ch;
	}

/**
Reports any error with the error number from error.h
@param msg Error message to be printed
@return The failure code
*/
int Error(char msg[])
	{
	/** Print the error message with the global error number*/
	printf("%s [Error NUMBER = %d]\n",msg,errno);
	PressKey();
	return EXIT_FAILURE;
	}

int main()
	{
	/** File stream for the pipe opened using popen()*/
	FILE* childProcessStream;
	/** Name of the FIFO file to be created*/
	char fifoFileName[] = "myfifofile";
	/** Child process path for FIFO*/
	char fifoExecFileName[] = "z:\\sys\\bin\\fifochild";
	/** Child process path for popen()*/
	char popenExecFileName[] = "z:\\sys\\bin\\ipcchild";
	/** Process ID of child process for FIFO*/
	pid_t fifoChildPid;
	/** Variables for storing return values of POSIX APIs*/
	int fifoRetVal;
	int unlinkResult;
	int fifoResult;
	/** File descriptor of stream opened by popen()*/
	int	childProcessFD;
	
	char **argv=(char**)malloc(2*sizeof(char*));
    argv[0]=(char*)malloc(50*sizeof(char));
	argv[1] = 0;
	strcpy(argv[0], fifoExecFileName);

	/** Create the FIFO file with execute permission to the group. However,
	this flag would not have any effect as the concept of a 'process group'
	does not exist in the Symbian platform Process Model*/
    unlinkResult=unlink(fifoFileName);
 	fifoResult = mkfifo(fifoFileName,S_IXGRP);
	/** mkfifo() returns -1 in case of an error*/
	if(fifoResult == -1)
		{
			Error("*** failure mkfifo ***");
			PressKey();
			return EXIT_FAILURE;
		}
	/** FIFO creation is successful, spawn the child process.*/
	fifoRetVal  = posix_spawn(&fifoChildPid, fifoExecFileName, NULL, NULL, argv, (char**)NULL);
	/** posix_spawn() returns a non-zero integer in case of an error*/
	free((void*)argv[0]);
	free((void*)argv);
	if(fifoRetVal != 0)
		{
		printf("failure posix_spawn [Error NUMBER = %d]\n",errno);
        unlinkResult=unlink(fifoFileName);
        if(unlinkResult!=0)
            {
            printf("failure posix_spawn [Error NUMBER = %d]\n",errno);
            }
		PressKey();
		return EXIT_FAILURE;
		}
	else
		{
		/** Open the FIFO file, parent reads data from this file*/
		int fifoFd = open(fifoFileName,O_RDONLY);
		/** open() returns -1 on failure*/
		if(fifoFd == -1)
			{
			/** Failed to open the FIFO*/
			Error("*** failure FIFO Open ***");
			PressKey();
			return EXIT_FAILURE;
			}
		else
			{
			/** Create a receive buffer and clear the buffer*/
			char buffer[100];
			int nbytes;
			memset(buffer,0,sizeof(buffer));
			/** Wait for data from the child process. Child process sends a string to the parent*/
			nbytes = read(fifoFd,buffer,sizeof(buffer));
			printf("\nBytes Received=%d, Message Received from fifochild using [FIFO]=%s",nbytes,buffer);
			/** Close the FIFO*/
			(void)close(fifoFd);
			}
		/** Create another child process using popen()*/
		childProcessStream = popen(popenExecFileName,"r");
		/** popen() returns Null if the pipe can not be created*/
		if(childProcessStream == NULL)
			{
			Error("\n Failure to create child process with popen()");
			PressKey();
			return EXIT_FAILURE;
			}
		else
			{
			/** Create a receive buffer and clear its contents before receiving any data from the child process*/
			char buffer[100];
			/** Number of bytes to be read from the pipe*/
			int nbytes;
			/** Use a file descriptor rather than a file stream*/
			childProcessFD = fileno(childProcessStream);
			memset(buffer,0,sizeof(buffer));
			printf("\n\nWaiting for message from Child[popen()]\n");
			/** Wait for data from the child process. Child process sends a string*/
			nbytes = read(childProcessFD,buffer,sizeof(buffer));
			printf("Bytes Received=%d, Message Received from ipcchild using[popen()]=%s\n[ok]\n",nbytes,buffer);
			/** Close the pipe*/
			pclose(childProcessStream);
			}
		/** Wait for the child process to finish its execution*/
		(void)waitpid(fifoChildPid,NULL,0);
		/** Delete the FIFO*/
		unlinkResult=unlink(fifoFileName);
		if(unlinkResult!=0)
			{
			Error("Unlink error");
			}
		}
	printf("Press any key to exit...");
	PressKey();
	return EXIT_SUCCESS;
	}
