// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the CTaskSchedule class.
//



/**
 @file
*/
#ifndef __TASKSCHEDULER_H__
#define __TASKSCHEDULER_H__

// Symbian platform includes
#include <csch_cli.h>

/**
CTaskSchedule is a class that publicly inherits from CBase class

The class demonstrates how to connect and register with the task scheduler server,
create persistent and transient schedules and to delete the persistent tasks 
and schedules.
*/
class CTaskSchedule: public CBase
	{
public:
	static CTaskSchedule* NewLC();

	~CTaskSchedule();
	
	void ConnectAndRegisterL();
	void PersistentScheduleL();
	void CreatePersistentScheduleL(TSchedulerItemRef& aRef, const TTsTime& aStartTime);
	void CreateTransientScheduleL();
	void DoesScheduledItemExistL(TSchedulerItemRef &aRef, TBool& aExists);
	void DeleteSchedulesL(TSchedulerItemRef &aRef, TScheduleFilter aFilter);
	
private:
	CTaskSchedule();
	void ConstructL();

private:
	/** Pointer to the console interface */
	CConsoleBase* iConsole;
	/** Handle to task scheduler interface*/
	RScheduler	iScheduler;
	
    };
    
#endif //__TASKSCHEDULER_H__
