// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// The following class opens the InverterOutQ message Queue and displays 
// recieved data in console.
//



/**
 @file
*/


#include "CMsgQActive.h"
#include "e32cons.h"

_LIT(KCommonFormat2,"%S");
_LIT(KTitle , "OutputMessage");

/**
Constructor
*/
CMsgQActive::CMsgQActive(TInt aPriority):CActive(aPriority)
	{
	CActiveScheduler::Add( this );
	}


CMsgQActive* CMsgQActive::NewL(TInt aPriority)
	{
	CMsgQActive* self=new(ELeave)CMsgQActive(aPriority);
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop(self);
	return self;
	}

/**
Opens the global message queue so that data can be recieved.
*/
void CMsgQActive::ConstructL()
	{
	iConsole = Console::NewL(KTitle, TSize(KConsFullScreen, KConsFullScreen));
	_LIT(KWelcomeScreen,".......Words recieved from the inverter......\n");
	iConsole->Printf(KWelcomeScreen);
	
	//Open the InverterOutQ Message Queue.
	_LIT(KGlobalInverterOutQ, "InverterOutQ");
	User::LeaveIfError(iInverterOutQ.OpenGlobal(KGlobalInverterOutQ));		
	}

/**
Recieve data from the InverterOut message queue,
requests notification when there is at least one message in the queue
*/
void CMsgQActive::StartRecieving()
	{
	iInverterOutQ.NotifyDataAvailable(iStatus);
	SetActive();
	}

CMsgQActive::~CMsgQActive()
	{
	}

/**
Cancel any outstanding request when stop command is given.
*/
void CMsgQActive::DoCancel()
	{
	//Cancel any data which is present in the message Queue.
	iInverterOutQ.CancelDataAvailable();
	delete iConsole;
	}

/**
This function recieves the message from inverter and display in the console.
*/

void CMsgQActive::RunL()
	{
	// Recieve all available messages from the message queue.
	iInverterOutQ.ReceiveBlocking(imsgQData);	
	
	//Print the recieved message in the output message console.
	iConsole->Printf(KCommonFormat2,&imsgQData);
	
	_LIT(KNextLine , "\n");
	iConsole->Printf(KNextLine);
	
	// Make asynchronous request to be notified when data is available
	iInverterOutQ.NotifyDataAvailable(iStatus);
	SetActive();
	}
