// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include <e32base.h>
#include <e32cons.h>
#include "example.h"
#include "searchsortexample.h"


_LIT(KTxtEPOC32EX,"EXAMPLES");
_LIT(KTxtExampleCode,"Symbian platform Example Code");
_LIT(KFormatFailed,"failed: leave code=%d");
_LIT(KTxtOK,"ok");
_LIT(KTxtPressAnyKey," [press any key to exit]");



//constants for MENU:

_LIT(KMenuRow0,"******************\n");
_LIT(KMenuRow1,"* Press a key\n");
_LIT(KMenuRow2,"* 1    Display The MessageEntry Header\n");
_LIT(KMenuRow3,"* 2    Simple Search Sort without Iterator\n");
_LIT(KMenuRow4,"* 3    Combined Search Sort without Iterator\n");
_LIT(KMenuRow5,"* 4    Search-Sort with Iterator\n");
_LIT(KMenuRow6,"* 5    Search-Sort with Query ID\n");
_LIT(KMenuRow7,"* Press Escape Key to Exit\n");
_LIT(KMenuRow8,"********************\n");


//Welcome Message.
_LIT(KMessageRow0,"************************************\n");
_LIT(KWelcomeMessage,"\n*Welcome To Search-Sort Example\n");
_LIT(KMessageRow2,"\n************************************\n");

_LIT(KNewLine,"\n");
_LIT(KSingleTab,"\t");
_LIT(KDoubleTab,"\t\t");
_LIT(KSpace,"   ");
_LIT(KFromFormat," From :");
_LIT(KToFormat," To :");
_LIT(KSubjectFormat," Subject :");
_LIT(KSizeFormat," Size :");
_LIT(KDateFormat," Date :");
_LIT(KTimeFormat," Time :");
_LIT(KSimpleSearchSort,"Simple Search Sort \n");
_LIT(KSearchSortSettings,"Provide inputs for the setting\n");
_LIT(KCombineSearchSort,"Combined Search Sort \n");
_LIT(KInvalidEntry,"Invalid Entry !!!!!! Enter either y/n\n");
_LIT(KWaitMessage,"Wait till the search is done.................\n");
_LIT(KReturnToMainMenu,"\nReturn to main menu by pressing ENTER key\nFor Exit press ESCAPE key\n");
_LIT(KMessageSummary,"********** Message Summary *****************\n");
_LIT(KTextFormat,"%c\n");
_LIT(KTextFormat1,"%c");
_LIT(KResultFormat,"The ResultCount =%d\n");
_LIT(KNoEntiresFound,"No Entries Found\n");
_LIT(KNoMenuOption,"Not a valid menu option\n");

// public.
static CConsoleBase* console; // write all your messages to this.
// private.
static void callExampleL(); // initialize with cleanup stack, then do example.

static void DisplayMenu();

//Constructor.

CKeyReader::CKeyReader(CConsoleBase* aConsole,CSearchsortExample* aExample)
    :CActive(EPriorityStandard),
    iConsole(aConsole),
    iSearchSortExample(aExample)

    {
	CActiveScheduler::Add(this);
	iCaseSensitivityON = EFalse;
	iWholeWordSearch = EFalse;
	iCombinedSearch= EFalse;
    }


//Destructor.
CKeyReader::~CKeyReader()
    {
    Cancel();
    }

 //Requesting Function, takes key inputs and calls RunL for handling the event generated.
void CKeyReader::StartL()
    {
	
    iConsole->ClearScreen();
    console->Write(KMessageRow0);
	console->Write(KWelcomeMessage);
	console->Write(KMessageRow2);

    DisplayMenu();
    
    iStatus = KRequestPending;
    SetActive();

    iConsole->Read(iStatus);
    CActiveScheduler::Start();
    // continues from this point when CActiveScheduler::Stop is called.
    User::LeaveIfError(iErrorCondition);
    }

void CKeyReader::RunL()
    {
    TBool exit = EFalse;
    // Get the key code.
	TUint8 option = iConsole->KeyCode();
	// Print the selected option.
	iConsole->Printf(KTextFormat,option);

	// Get the numeric value for key pressed.
	TInt number = option - (TUint)'0';

	if(number>0 && number<10)
		{
		switch(number)
			{
			case 1:
				{
	    		_LIT(KDisplayMessage,"Displaying header info for Message Entries \n");
	    		iConsole->Printf(KDisplayMessage);
				
	    		for(TInt index=0;index<KMaxEntryCount;index++)
					{
	    			TBuf<128> displaymessage(KFromFormat);
	    			displaymessage.Append(iFrominfo[index]);
	    			displaymessage.Append(KToFormat);
	    			displaymessage.Append(iToinfo[index]);
	    			displaymessage.Append(KSubjectFormat);
	    			displaymessage.Append(iSubjectinfo[index]);
	    			displaymessage.Append(KNewLine);
	    			iConsole->Printf(displaymessage);

					}
				iConsole->Printf(KReturnToMainMenu);
				}
	    		break;
			case 2:
				{
	    		ResetSettings();
	    		iConsole->Printf(KSimpleSearchSort);
	    		iConsole->Printf(KSearchSortSettings);
	    		if(!SearchSortSettings())
	    		    {
	    		    iConsole->Printf(KReturnToMainMenu);
	    		    break;		
	    		    }
	    		iConsole->Printf(KWaitMessage);

    			iSearchSortExample->SearchSortRequestWithoutIteratorL(iSender,iCaseSensitivityON,iWholeWordSearch,iCombinedSearch,iResultCount);

	    		iConsole->Printf(KResultFormat,iResultCount);
	    		if(iResultCount)
					DisplayMessageSummary();
	    		else
					iConsole->Printf(KNoEntiresFound);

	    		iConsole->Printf(KReturnToMainMenu);
				}
	    		break;
			case 3:
				{
				_LIT(KInfoMessage1,"\nSearch value is set on \"To\", \"Subject\" and \"Size\" fields \n\"To\" field is provided through user input\n\"Size\" part is hard coded to 100 and \"Subject\" to GoodEmail\n");
	    		ResetSettings();
	    		iCombinedSearch=ETrue;
	    		iConsole->Printf(KCombineSearchSort);
	    		iConsole->Printf(KInfoMessage1);
	    		iConsole->Printf(KNewLine);
	    		iConsole->Printf(KSearchSortSettings);
	    		if(!SearchSortSettings())
	    		    {
	    		    iConsole->Printf(KReturnToMainMenu);
	    		    break;		
	    		    }

	   			iConsole->Printf(KWaitMessage);
    			iSearchSortExample->SearchSortRequestWithoutIteratorL(iSender,iCaseSensitivityON,iWholeWordSearch,iCombinedSearch,iResultCount);

    			iConsole->Printf(KResultFormat,iResultCount);
    			if(iResultCount)
					DisplayMessageSummary();
	    		else
					iConsole->Printf(KNoEntiresFound);

    			iConsole->Printf(KReturnToMainMenu);
				}
	    		break;
			case 4:
				{
	    		_LIT(KSearchSortWithIterator,"Search-Sort with Iterator \n");
	    		_LIT(KInfoMessage2,"The Search is made on Size, hard coded to value 100\n");
	    		_LIT(KResultMessage1,"Searching By Iterator done, ResultCount=%d\n");

	    		iConsole->Printf(KSearchSortWithIterator);
	    		iConsole->Printf(KInfoMessage2);
	    		iSearchSortExample->SearchSortRequestWithIteratorL(iResultCount);
	    		iConsole->Printf(KResultMessage1,iResultCount);
	    		iConsole->Printf(KReturnToMainMenu);
				}
	    		break;
			case 5:
				{
	    		_LIT(KSearchSortQueryID,"Search-Sort using Query ID \n");
	    		_LIT(KResultMessage2,"Searching By QueryID done, ResultCount=%d\n");

	    		iConsole->Printf(KSearchSortQueryID);
	    		iSearchSortExample->SearchSortRequestByQueryIdL(iResultCount);
	    		iConsole->Printf(KResultMessage2,iResultCount);
	    		if(iResultCount)
					DisplayMessageSummary();
	    		else
					iConsole->Printf(KNoEntiresFound);

	    		iConsole->Printf(KReturnToMainMenu);
				}
	    		break;
			default:
				{
				iConsole->Printf(KNoMenuOption);
				exit=ETrue;
		        break;	
				}
			}
		}
	else if(option==EKeyEscape)
		{
		exit=ETrue;
		}
	else if(option==EKeyEnter)
		{
		DisplayMenu();
		exit=EFalse;
		}
	else
		{
		iConsole->Printf(KNoMenuOption);
		}
	if (exit)
		{
		Cancel();
		CActiveScheduler::Stop();
		}
	else
		{
		iStatus = KRequestPending;
		SetActive();
		iConsole->Read(iStatus);
		}
  	}

void CKeyReader::DoCancel()
    {

    }

TInt CKeyReader::RunError(TInt aError)
    {
    iErrorCondition = aError;
    CActiveScheduler::Stop();
    return KErrNone;
    }

//Function for creating message entries.
void CKeyReader::CreateMessageEntriesL()
	{
	//Making settings before creating the message.
	iSearchSortExample->CreateClientRegistryL();
	iSearchSortExample->CreatePopAndSmtpAccountL();

	for(TInt index=0;index<KMaxEntryCount;index++)
		{
		iSearchSortExample->CreateSmtpMessageL(index,iFrominfo[index],iToinfo[index],iSubjectinfo[index]);
		}
	}

//Function for Displaying message summary.
void CKeyReader::DisplayMessageSummary()
	{
	iConsole->Printf(KNewLine);
	iConsole->Printf(KMessageSummary);
	TBuf<200> messageSummaryTable;
	messageSummaryTable.Append(KToFormat);
	messageSummaryTable.Append(KDoubleTab);
	messageSummaryTable.Append(KSingleTab);
	messageSummaryTable.Append(KSizeFormat);
	messageSummaryTable.Append(KDoubleTab);
	messageSummaryTable.Append(KDateFormat);
	messageSummaryTable.Append(KDoubleTab);
	messageSummaryTable.Append(KTimeFormat);
	messageSummaryTable.Append(KDoubleTab);
	messageSummaryTable.Append(KSubjectFormat);
	messageSummaryTable.Append(KDoubleTab);
	messageSummaryTable.Append(KNewLine);
	iConsole->Printf(messageSummaryTable);
	
	for(TInt index=0;index<iResultCount;index++)
		{
		TResultSummary tempsummary=iSearchSortExample->iTResultSummary[index];
		TBuf<200> displaymessageSummary;
		displaymessageSummary.Append(tempsummary.iToText);
		displaymessageSummary.Append(KSpace);
		displaymessageSummary.AppendNum(tempsummary.iSize);
		displaymessageSummary.Append(KDoubleTab);
		displaymessageSummary.Append(tempsummary.iDatestring);
		displaymessageSummary.Append(KSingleTab);
		displaymessageSummary.Append(tempsummary.iTimestring);
		displaymessageSummary.Append(KDoubleTab);
		displaymessageSummary.Append(tempsummary.iSubjectText);
		displaymessageSummary.Append(KNewLine);
		iConsole->Printf(displaymessageSummary);
		}
	}

//Settings done for search-sort depending on the user input.
TBool CKeyReader::SearchSortSettings()
	{
	_LIT(KText,"Enter the To field to be searched on \n e.g exampleUser,exampleUser2@nokia.com etc.....\n");
	iConsole->Printf(KText);
	iSender.Delete(0,iSender.Length());
	TKeyCode string;

	while((string=iConsole->Getch())!=EKeyEnter)
		{
		iConsole->Printf(KTextFormat1,string);
		iSender.Append(string);
		}

	iConsole->Printf(KNewLine);
	iConsole->Printf(iSender);
	iConsole->Printf(KNewLine);
	iSender.Trim();
	if(iSender.Length()<= 0)
		{
		_LIT(KInValidMsg,"Enter a valid field to be searched\n");
		iConsole->Printf(KInValidMsg);
		return EFalse;
		}
	_LIT(KText1,"Case Sensitivity Search ON? y/n\n");
	iConsole->Printf(KText1);

	while(ETrue)
		{
		string=iConsole->Getch();
		if(string=='y')
			{
			iConsole->Printf(KTextFormat,string);
			iCaseSensitivityON = ETrue;
			break;
			}
		else if(string=='n')
			{
			iConsole->Printf(KTextFormat,string);
			iCaseSensitivityON = EFalse;
			break;
			}
		else
			{
			iConsole->Printf(KInvalidEntry);
			}
		}

	_LIT(KText2,"Whole Word Search ON? y/n\n");
	iConsole->Printf(KText2);

	while(ETrue)
		{
		string=iConsole->Getch();

		if(string=='y')
			{
			iConsole->Printf(KTextFormat,string);
			iWholeWordSearch = ETrue;
			break;
			}
		else if(string=='n')
			{
			iConsole->Printf(KTextFormat,string);
			iWholeWordSearch = EFalse;
			break;
			}
		else
			{
			iConsole->Printf(KInvalidEntry);
			}
		}
	return ETrue;
	}

//Reseting the search-sort settings made.
void CKeyReader::ResetSettings()
	{
	iCaseSensitivityON =EFalse;
	iWholeWordSearch = EFalse;
	iCombinedSearch=EFalse;
	}


static void DisplayMenu()
    {
    console->Printf(KMenuRow0);
    console->Printf(KMenuRow1);
    console->Printf(KMenuRow2);
    console->Printf(KMenuRow3);
    console->Printf(KMenuRow4);
    console->Printf(KMenuRow5);
    console->Printf(KMenuRow6);
    console->Printf(KMenuRow7);
    console->Printf(KMenuRow8);
	
    }

static void MainL()
    {

	CSearchsortExample* example=CSearchsortExample::NewL();
	CleanupStack::PushL(example);

	CKeyReader* reader = new (ELeave) CKeyReader(console,example);
    CleanupStack::PushL(reader);

    reader->CreateMessageEntriesL();
    reader->StartL();
    example->DeleteAccountsL();	

    CleanupStack::PopAndDestroy(reader);
    CleanupStack::PopAndDestroy(example);
    }

// do the example.
static void DoStartL()
    {
	// Create active scheduler (to run active objects).
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler();
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	MainL();

	// Delete active scheduler.
	CleanupStack::PopAndDestroy(scheduler);
	}

static void callExampleL() // initialize and call example code under cleanup stack.
    {
	console=Console::NewL(KTxtExampleCode,TSize(KConsFullScreen,KConsFullScreen));
	CleanupStack::PushL(console);
	TRAPD(error,DoStartL()); // perform example function.
	if (error)
		console->Printf(KFormatFailed, error);
	else
		console->Printf(KTxtOK);
	console->Printf(KTxtPressAnyKey);
	console->Getch(); // get and ignore character.
	CleanupStack::PopAndDestroy(); // close console.
    }

extern TInt E32Main() // main function called by E32.
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack.

	if(cleanup == NULL)
        {
        return KErrNoMemory;
        }

	TRAPD(error,callExampleL()); // more initialization, then do example.
	__ASSERT_ALWAYS(!error,User::Panic(KTxtEPOC32EX,error));
	delete cleanup; // destroy clean-up stack.
	__UHEAP_MARKEND;
	return 0; // and return.
    }


