// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef EXAMPLE_H
#define EXAMPLE_H

#define KMaxEntryCount 5    //Keeping message entry count.
class CSearchsortExample;    //Forward Declaration.

/**
Reads keypresses in asynchronous way
and calls example functions.
*/

class CKeyReader : public CActive
	{

public:

	/**
	Constructor.
	*/
	CKeyReader(CConsoleBase* aConsole,CSearchsortExample* aExample);

	/**
	Desructor.
	*/
	~CKeyReader();

	/**
	Request Function, this takes the key inputs.
	*/
	void StartL();

	void RunL();
	void DoCancel();

	/**
	Handling leaving of RunL.
	*/
	TInt RunError(TInt aError);


	/**
	Function for making search-sort settings.
	*/
	TBool SearchSortSettings();

	/**
	Function for resetting search-sort settings.
	*/
	void ResetSettings();

	/**
	Function for creating message entries.
	*/
	void CreateMessageEntriesL();

	/**
	Function for displaying message summary.
	*/
	void DisplayMessageSummary();
public:

	/**
	Buffer for getting message header info
	*/
	TBuf<32> iFrominfo[KMaxEntryCount];
	TBuf<32> iToinfo[KMaxEntryCount];
	TBuf<32> iSubjectinfo[KMaxEntryCount];

	/**
	Variables taking user input and hence used in search-sort settings
	*/
	TBuf<64> iSender;
	TBool iCaseSensitivityON,iWholeWordSearch,iCombinedSearch;
private:
	/**
	Pointer to console.
	Not owned.
	*/
	CConsoleBase* iConsole;

	/**
	Pointer to CSearchsortExample.
	*/
	CSearchsortExample* iSearchSortExample;

	/**
	Leave code catch.
	*/
	TInt iErrorCondition;
	/**
	search-sort Result count.
	*/
	TInt iResultCount;

	};

#endif//EXAMPLE_H
