// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the CMessAsyncWaiter class.
//



/**
 @file
*/

#ifndef __MESS_ASYNCWAITER_H_
#define __MESS_ASYNCWAITER_H_

#include <e32base.h>

/**
CMessAsyncWaiter is a class that publicily inherits the class CActive.
CActive is core class of the active object abstraction.
It encapsulates both issuing a request to an asynchronous service provider 
and handling the completed requests.
*/
class CMessAsyncWaiter : public CActive
	{
public:
	static CMessAsyncWaiter* NewL();
	~CMessAsyncWaiter();

	void StartAndWait();
	TInt Result() const;
private:
	CMessAsyncWaiter();
	// CActive implementation.
	virtual void RunL();
	virtual void DoCancel();
private:
	TInt iError;
	};
#endif // __MESS_ASYNCWAITER_H_
