// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "searchsortexample.h"
#include "mAsyncWaiter.h"
#include <msvsearchsortoperation.h>

void CSearchsortExample::HandleSessionEventL(TMsvSessionEvent aEvent, TAny*, TAny*, TAny*)
	{

	switch (aEvent)
		{
		case MMsvSessionObserver::EMsvServerReady:
			break;
		case MMsvSessionObserver::EMsvEntriesCreated:
			break;
		default:
			break;
		}
	}

/**
 ApI Implementation
 */

 CSearchsortExample* CSearchsortExample::NewL()
 	{
	CSearchsortExample* self=new(ELeave)CSearchsortExample;
	CleanupStack::PushL(self);
	self->ConstructL();
	CleanupStack::Pop();
	return self;
	}
/**
Constructor.
*/
CSearchsortExample::CSearchsortExample()
	{
	}

void CSearchsortExample::ConstructL()
	{
	}

/**
Destructor.
*/
 CSearchsortExample::~ CSearchsortExample()
	{
	if(iMtm)
		{
		delete iMtm;
		iMtm = NULL;
		}
	if(iClientRegistry)
		{
		delete iClientRegistry;
		iClientRegistry  = NULL;
		}
	if(iSearch)
		{
		delete iSearch;
		iSearch = NULL;
		}
	if(iSession)
		{
		delete iSession;
		iSession = NULL;
		}

	iQueryIdTable.Close();
	iTResultSummary.Close();

	}


/**
Starts a message server session.
Creates the client side mtm registry and pop client mtm.
@leave KErrNoMemory, KErrNotFound, KErrBadLibraryEntryPoint.
*/
void  CSearchsortExample::CreateClientRegistryL()
	{
	//Creates a session with message server.
	iSession = CMsvSession::OpenAsyncL(*this);
	CleanupStack::PushL(iSession);

	iSearch = CMsvSearchSortOperation::NewL(*iSession);
	CleanupStack::PushL(iSearch);

	// Create a client-side MTM registry.
	iClientRegistry = CClientMtmRegistry::NewL(*iSession,KMsvDefaultTimeoutMicroSeconds32);
	if (iClientRegistry != NULL && iClientRegistry->IsPresent(KUidMsgTypePOP3))
		{
		CleanupStack::PushL(iClientRegistry);
		}
	// Create a Client-side MTM object for the specified MTM UID.
	iMtm = (CPop3ClientMtm*)iClientRegistry->NewMtmL(KUidMsgTypePOP3);

	CleanupStack::Pop(3,iSession); //iClientRegistry,iSession,iSearch.
    }

/**
Creates a pop account and an smtp account.
Sets the pop server address to the system address.
Sets the login name and password.
@leave system wide error codes
*/
void  CSearchsortExample::CreatePopAndSmtpAccountL()
	{
	CEmailAccounts* emailAccounts = CEmailAccounts::NewLC();
	CImPop3Settings* settings = new(ELeave) CImPop3Settings();
	CleanupStack::PushL(settings);

	CImIAPPreferences* popIAP = CImIAPPreferences::NewLC();

	// Set the server address to system address.
	settings->SetServerAddressL(KPopServer);
	settings->SetLoginNameL(KPopLoginName);
	settings->SetPasswordL(KPopPassword);
	settings->SetPort(KPortValue);

	// Create a Pop account.
	iPopAccount = emailAccounts->CreatePopAccountL(KTxtAccountName, *settings,*popIAP,EFalse);

	CImSmtpSettings *smtpSettings = new (ELeave) CImSmtpSettings();
	CleanupStack::PushL(smtpSettings);

	emailAccounts->PopulateDefaultSmtpSettingsL(*smtpSettings, *popIAP);

 	// Create an Smtp acoount.
	iSmtpAccount = emailAccounts->CreateSmtpAccountL(iPopAccount, *smtpSettings, *popIAP, EFalse);

	emailAccounts->SetDefaultSmtpAccountL(iSmtpAccount);

	smtpSettings->SetServerAddressL(KSmtpServerAddress);
	smtpSettings->SetEmailAliasL(KEmailAlias);
	smtpSettings->SetEmailAddressL(KSmtpEmailAddress);
	smtpSettings->SetReplyToAddressL(KSmtpEmailAddress);
	smtpSettings->SetReceiptAddressL(KSmtpEmailAddress);
	smtpSettings->SetPort(KSmtpPortValue);

	// Add IAP to the IAP preferences.
	CImIAPPreferences* prefs = CImIAPPreferences::NewLC();
	TImIAPChoice iap;
	TInt iapID = 0;
	CMDBSession* dbSession = CMDBSession::NewL(KCDVersion1_1);
	CleanupStack::PushL(dbSession);
	CCDConnectionPrefsRecord *connPrefRecord = static_cast<CCDConnectionPrefsRecord*>(CCDRecordBase::RecordFactoryL(KCDTIdConnectionPrefsRecord));
	CleanupStack::PushL(connPrefRecord);

	// Set the direction of connection.
	connPrefRecord->iDirection = ECommDbConnectionDirectionOutgoing;
	connPrefRecord->iRanking = 1;
	if(!connPrefRecord->FindL(*dbSession))
		{
		User::Leave(KErrNotFound);
		}
	iapID = connPrefRecord->iDefaultIAP;
	iap.iIAP = iapID;
	iap.iDialogPref = ECommDbDialogPrefDoNotPrompt;
	prefs->AddIAPL(iap);

	emailAccounts->GetSmtpAccountL(iSmtpAccount.iSmtpService, iSmtpAccount);
	emailAccounts->SaveSmtpSettingsL(iSmtpAccount,*smtpSettings);
	emailAccounts->SaveSmtpIapSettingsL(iSmtpAccount, *prefs);

	//Deleting the message entries if they exist for resetting.
	DeleteSmtpMessageL();
	//connPrefRecord, dbSession, prefs, smtpSettings, popIAP, settings, emailAccounts.
	CleanupStack::PopAndDestroy(7,emailAccounts);
	}

/**
Creates an smtp message,stores and then commits settings to a specified message store.
@leave KErrNoMemory,KErrNotFound,KErrAccessDenied,Standard
*/
void  CSearchsortExample::CreateSmtpMessageL(TInt aindex,TDes& aFrominfo,TDes& aToinfo,TDes& aSubjectinfo)
	{

	TMsvId inboxId = KMsvGlobalInBoxIndexEntryId;

	// Set the context to the folder in which message has to be created.
	CMsvEntry*	entry = CMsvEntry::NewL(*iSession,inboxId,TMsvSelectionOrdering());
	CleanupStack::PushL(entry);
	entry->SetEntryL(inboxId);

	CMessAsyncWaiter* waiter = CMessAsyncWaiter::NewL();
	CleanupStack::PushL(waiter);

	TMsvEmailTypeList msvEmailTypeList = 0;
	TMsvPartList partList = (KMsvMessagePartBody | KMsvMessagePartAttachments|KMsvMessagePartTo|KMsvMessagePartFrom|KMsvMessagePartSubject);

	CImEmailOperation* emailOperation = CImEmailOperation::CreateNewL(waiter->iStatus, *iSession,KMsvGlobalInBoxIndexEntryId, partList, msvEmailTypeList, KUidMsgTypeSMTP);
	CleanupStack::PushL(emailOperation);
	waiter->StartAndWait();

	TMsvId temp;
	TPckgC<TMsvId> paramPack(temp);
	const TDesC8& progBuf = emailOperation->ProgressL();

	paramPack.Set(progBuf);
	TMsvId newMessageId;
	newMessageId = paramPack();


	entry->SetEntryL(newMessageId);

	CMsvStore* store = entry->EditStoreL();
	CleanupStack::PushL(store);

	//Setting the Header for message entry.
	CImHeader* emailEntry = CImHeader::NewLC();
	emailEntry->RestoreL(*store);

	//Setting the Header according to the message entry count.
	switch(aindex)
		{
		case 0:
			{
			emailEntry->SetFromL((TDesC8&)KFrom1);
			emailEntry->SetSubjectL((TDesC&)KSubject1);
			emailEntry->ToRecipients().AppendL((TDesC&)KTo1);
			aToinfo.Copy(KTo1);
			}
			break;
		case 1:
			{
			emailEntry->SetFromL((TDesC8&)KFrom2);
			emailEntry->SetSubjectL((TDesC&)KSubject2);
			emailEntry->ToRecipients().AppendL((TDesC&)KTo2);
			aToinfo.Copy(KTo2);
			}
			break;
		case 2:
			{
			emailEntry->SetFromL((TDesC8&)KFrom3);
			emailEntry->SetSubjectL((TDesC&)KSubject3);
			emailEntry->ToRecipients().AppendL((TDesC&)KTo3);
			aToinfo.Copy(KTo3);
			}
			break;
		case 3:
			{
			emailEntry->SetFromL((TDesC8&)KFrom4);
			emailEntry->SetSubjectL((TDesC&)KSubject4);
			emailEntry->ToRecipients().AppendL((TDesC&)KTo4);
			aToinfo.Copy(KTo4);
			}
			break;
		case 4:
			{
			emailEntry->SetFromL((TDesC8&)KFrom5);
			emailEntry->SetSubjectL((TDesC&)KSubject5);
			emailEntry->ToRecipients().AppendL((TDesC&)KTo5);
			aToinfo.Copy(KTo5);
			}
			break;
		default:
			break;
		}

	aFrominfo.Copy(emailEntry->From());
	aSubjectinfo.Copy(emailEntry->Subject());

	// Paragraph format layer for the rich text object.
	CParaFormatLayer* paraFormatLayer = CParaFormatLayer::NewL();
	CleanupStack::PushL(paraFormatLayer);
	// Character format layer for the rich text object.
	CCharFormatLayer* charFormatLayer = CCharFormatLayer::NewL();
	CleanupStack::PushL(charFormatLayer);

	CRichText* bodyText = CRichText::NewL(paraFormatLayer, charFormatLayer, CEditableText::EFlatStorage, 256);
	CleanupStack::PushL(bodyText);

	// Inserts the contents of a buffer into the document at specified position.
	bodyText->InsertL(0, KBodyContents);
	store->StoreBodyTextL(*bodyText);
	emailEntry->StoreL(*store);
	// Store the changes permanently.
	store->CommitL();

	// bodyText, charFormatLayer, paraFormatLayer, emailEntry, store, emailOperation, waiter, entry.
	CleanupStack::PopAndDestroy(8,entry);
	}


/**
Seachsort request without iterator.
*/
void CSearchsortExample::SearchSortRequestWithoutIteratorL(TDes& aSearchtext,TBool aCaseSensitivity,TBool aWholeWordSearch,TBool aCombinedSearch,TInt& aResultCount)
	{

	//CMessAsyncWaiter for async request.
	CMessAsyncWaiter* waiter = CMessAsyncWaiter::NewL();
	CleanupStack::PushL(waiter);

	//Create instance of CMsvSearchSortQuery to create a search-sort query.
	CMsvSearchSortQuery* searchQuery = CMsvSearchSortQuery::NewL();
	CleanupStack::PushL(searchQuery);

	//Search-sort operation is performed on a specified folder. (e.g, on INBOX, SENT ITEMS,
	//DRAFT, OUTBOX or any user created folder). Needs to sets the value of the folder entry.
	searchQuery->SetParentId(KMsvGlobalInBoxIndexEntryIdValue);
	//Sets the type of result expected out of the search-sort operation.
	searchQuery->SetResultType(EMsvResultAsTMsvEntry);
	searchQuery->SetWholeWord(aWholeWordSearch);
	searchQuery->SetCaseSensitiveOption(aCaseSensitivity);
	searchQuery->SetWildCardSearch(EFalse);

	//Adding search option.
	searchQuery->AddSearchOptionL(EMsvTo,aSearchtext, EMsvEqual);

	//Combined search-sort we can add some more AddSearchOptionL function.
	if(aCombinedSearch)
		{
		TInt size = KSize;
		//Adding search option.
		searchQuery->AddSearchOptionL(EMsvSize, size, EMsvLessThanOrEqual);
		searchQuery->AddSearchOptionL(EMsvSubject, KSubjectSearch, EMsvEqual);

		}

	//Adding sort option.
	searchQuery->AddSortOptionL(EMsvDate, EMsvSortAscending);

	//Poping the searchQuery object from cleanupstack as here after.
	//the control transfers to CMsvSearchSortOperation by making a call to RequestL.
	CleanupStack::Pop(searchQuery);

	//Search-sort Request.
	iSearch->RequestL(searchQuery, ETrue, waiter->iStatus);
	waiter->StartAndWait();

	//To hold Search-sort results.
	RArray<TMsvEntry> resultArray;

	//After the completion RequestL(), GetResultsL function provides a list of
	//index entry Id objects (TMsvEntry).
	TRAPD(ret, iSearch->GetResultsL(resultArray));

	iTResultSummary.Reset();

	TMsvId inboxId=KMsvGlobalInBoxIndexEntryId;
	CMsvEntry*	entry = CMsvEntry::NewL(*iSession,inboxId,TMsvSelectionOrdering());
	CleanupStack::PushL(entry);

	if(ret == KErrNone)
		{
		//for getting and the entry details.
		for(TInt index=0;index<resultArray.Count();index++)
			{
			TResultSummary tempdata;
			TMsvEntry tempentry;
			TTime date;

			tempentry=resultArray[index];
			entry->SetEntryL(tempentry.Id());

			//For obtaining header info.
			CMsvStore* store = entry->ReadStoreL();
			CleanupStack::PushL(store);
			CImHeader* emailEntry = CImHeader::NewLC();
			emailEntry->RestoreL(*store);

			tempdata.iSubjectText.Copy(emailEntry->Subject());
			tempdata.iToText.Copy((emailEntry->ToRecipients())[0]);
			tempdata.iSize=tempentry.iSize;
			date=tempentry.iDate;
			date.FormatL(tempdata.iDatestring,KFormat1);
			date.FormatL(tempdata.iTimestring,KFormat2);
			iTResultSummary.Append(tempdata);

			CleanupStack::PopAndDestroy(2,store); //emailEntry, store.
			}
		aResultCount=iSearch->GetResultCountL();
		}
	//After the completion of RequestL(), GetQueryIdL function provides the query Id.
	//corresponding to a search-sort query.
	iQueryId = iSearch->GetQueryIdL();

	iExampleTQueryTable.iQueryId=iQueryId;
	iExampleTQueryTable.iResultType=EMsvResultAsTMsvEntry;
	iQueryIdTable.Append(iExampleTQueryTable);

	resultArray.Close();
	CleanupStack::PopAndDestroy(2,waiter); //entry, waiter.
	}

/**
Seachsort request with iterator.
*/
void CSearchsortExample::SearchSortRequestWithIteratorL(TInt& aResultCount)
	{

	//CMessAsyncWaiter for async request.
	CMessAsyncWaiter* waiter = CMessAsyncWaiter::NewL();
	CleanupStack::PushL(waiter);

	//Create instance of CMsvSearchSortQuery to create a search-sort query.
	CMsvSearchSortQuery* searchQuery = CMsvSearchSortQuery::NewL();
	CleanupStack::PushL(searchQuery);

	//Search-sort operation is performed on a specified folder. (e.g, on INBOX, SENT ITEMS,
	//DRAFT, OUTBOX or any user created folder). Needs to sets the value of the folder entry.
	searchQuery->SetParentId(KMsvGlobalInBoxIndexEntryIdValue);
	//Sets the type of result expected out of the search-sort operation.
	searchQuery->SetResultType(EMsvResultAsTMsvId);
	searchQuery->SetWholeWord(ETrue);
	searchQuery->SetCaseSensitiveOption(EFalse);
	searchQuery->SetWildCardSearch(EFalse);


	TInt size = KSize;
	//Add search option.
	searchQuery->AddSearchOptionL(EMsvSize, size, EMsvLessThanOrEqual);

	//Add sort option.
	searchQuery->AddSortOptionL(EMsvDate, EMsvSortAscending);

	//to enable Iterator.
	TInt iterator = 1;

	//Poping the searchQuery object from cleanupstack as here after.
	//the control transfers to CMsvSearchSortOperation by making a call to RequestL.
	CleanupStack::Pop(searchQuery);
	//Search-sort Request.
	iSearch->RequestL(searchQuery, ETrue, waiter->iStatus,iterator);
	waiter->StartAndWait();

	//Array to copy Search-sort results.
	RArray<TMsvId> resultArray;
	TMsvId resultAsTMsvId;


	//Gets the TMsvId of a single index entry object at a time.
	//GetNextResultL function is used when getting the results using iterative mechanism
	//and it returns remaining search-sort results Count.
	while(iSearch->GetNextResultL(resultAsTMsvId))
		{
		resultArray.AppendL(resultAsTMsvId);
		}

	aResultCount=iSearch->GetResultCountL();

	resultArray.Close();
	CleanupStack::PopAndDestroy(waiter); //waiter.
	}

/**
Seachsort request by QueryId.
*/
void CSearchsortExample::SearchSortRequestByQueryIdL(TInt& aResultCount)
	{


	//CMessAsyncWaiter for async request.
	CMessAsyncWaiter* waiter = CMessAsyncWaiter::NewL();
	CleanupStack::PushL(waiter);

	//Search-sort Request by QueryId.
	iSearch->RequestL(iQueryId, waiter->iStatus);
	waiter->StartAndWait();


	//To hold Search-sort results.
	TInt count=iQueryIdTable.Count();
	TQueryTable tempdata;

	TMsvId inboxId=KMsvGlobalInBoxIndexEntryId;
	CMsvEntry*	entry = CMsvEntry::NewL(*iSession,inboxId,TMsvSelectionOrdering());
	CleanupStack::PushL(entry);

	iTResultSummary.Reset();
	for(TInt index=0;index<count;index++)
		{
		tempdata=iQueryIdTable[index];
		if(tempdata.iQueryId==iQueryId)
			{
			if(tempdata.iResultType==EMsvResultAsTMsvId)
				{
				RArray<TMsvId> resultArray;
				TRAPD(ret, iSearch->GetResultsL(resultArray));
				if(ret == KErrNone)
					{
					TInt count = resultArray.Count();
					aResultCount=count;
					}
				resultArray.Close();
				}
			else if(tempdata.iResultType==EMsvResultAsTMsvEntry)
				{
				RArray<TMsvEntry> resultArray;
				TRAPD(ret, iSearch->GetResultsL(resultArray));
				if(ret == KErrNone)
					{
					TInt count = resultArray.Count();
					aResultCount=count;

					//for getting the entry details.
					for(TInt index=0;index<count;index++)
						{
						TResultSummary tempdata;
						TMsvEntry tempentry;
						TTime date;


						tempentry=resultArray[index];
						entry->SetEntryL(tempentry.Id());

						//for getting header info.
						CMsvStore* store = entry->ReadStoreL();
						CleanupStack::PushL(store);
						CImHeader* emailEntry = CImHeader::NewLC();
						emailEntry->RestoreL(*store);


						tempdata.iSubjectText.Copy(emailEntry->Subject());
						tempdata.iToText.Copy((emailEntry->ToRecipients())[0]);
						tempdata.iSize=tempentry.iSize;
						date=tempentry.iDate;
						date.FormatL(tempdata.iDatestring,KFormat1);
						date.FormatL(tempdata.iTimestring,KFormat2);
						iTResultSummary.Append(tempdata);

						CleanupStack::PopAndDestroy(2,store);
						}
					}
					resultArray.Close();
				}
			}
		}
	CleanupStack::PopAndDestroy(2,waiter); // entry, waiter.
	}

/**
Deleting Smtp message entries
*/
void  CSearchsortExample::DeleteSmtpMessageL()
	{
	//CMessAsyncWaiter for async request.

	CMessAsyncWaiter* waiter = CMessAsyncWaiter::NewL();
	CleanupStack::PushL(waiter);

	TInt mycount;
	TMsvId inboxId = KMsvGlobalInBoxIndexEntryId;
	CMsvEntry*	messagingEntry = CMsvEntry::NewL(*iSession,inboxId,TMsvSelectionOrdering());
	CleanupStack::PushL(messagingEntry);
	messagingEntry->SetEntryL(inboxId);

	CMsvEntrySelection* filteredMessageIds =messagingEntry->ChildrenL();
	CleanupStack::PushL( filteredMessageIds);
	 mycount=filteredMessageIds->Count();
	if(mycount)
		{
		CMsvOperation* operation = messagingEntry->DeleteL(*filteredMessageIds,waiter->iStatus);
		CleanupStack::PushL(operation);
		waiter->StartAndWait();
		CleanupStack::PopAndDestroy();
		}
	CleanupStack::PopAndDestroy(3,waiter); //filteredMessageIds, messagingEntry, waiter.
	}

void CSearchsortExample::DeleteAccountsL()
	{

	CEmailAccounts*	accounts = CEmailAccounts::NewLC();

	RArray<TPopAccount>	pop3Accounts;
	CleanupClosePushL(pop3Accounts);
	accounts->GetPopAccountsL(pop3Accounts);
	TInt	count = pop3Accounts.Count();
	TInt	index=0;
	for( index = 0; index < count; index++ )
		{
		TPopAccount	id = pop3Accounts[index];

		TRAPD(err,accounts->DeletePopAccountL( id ));
		if(err!=KErrNone)
			{
			User::Panic(KUserPanic, err);
			}
		}

	RArray<TImapAccount>	imap4Accounts;
	CleanupClosePushL(imap4Accounts);
	accounts->GetImapAccountsL(imap4Accounts);
	count = imap4Accounts.Count();
	for( TInt index = 0; index < count; index++ )
		{
		TImapAccount	id = imap4Accounts[index];
		TRAPD(err,accounts->DeleteImapAccountL( id ));
		if(err!=KErrNone)
			{
			User::Panic(KUserPanic, err);
			}
		}

	RArray<TSmtpAccount>	smtpAccounts;
	CleanupClosePushL(smtpAccounts);
	accounts->GetSmtpAccountsL(smtpAccounts);

    count = smtpAccounts.Count();
    for( TInt index = 0; index < count; index++ )
		{
		TSmtpAccount	id = smtpAccounts[index];

		TRAPD(err,accounts->DeleteSmtpAccountL( id ));
		if(err!=KErrNone)
			{
			User::Panic(KUserPanic, err);
			}
		}
	CleanupStack::PopAndDestroy(4, accounts);
	}

