// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef SEARCHSORTEXAMPLE_H
#define SEARCHSORTEXAMPLE_H

#include <mtclreg.h>
#include "pop3set.h"
#include "popcmtm.h"
#include <mtclbase.h>
#include <e32std.h>

#include <msvsearchsortquery.h>
#include <msvsearchsortoperation.h>
#include <msvstd.h>
#include <msvids.h>
#include <msvuids.h>
#include <msvapi.h>

#include <iapprefs.h>
#include <cemailaccounts.h>

#include <es_sock.h>
#include <commdb.h>
#include <cdbpreftable.h>
#include <commdbconnpref.h>
#include <commsdattypesv1_1.h>
#include <commsdat.h>
using namespace CommsDat;

_LIT(LDD_NAME,"ECOMM");

#if defined (__WINS__)
_LIT(PDD_NAME,"ECDRV");
#else
_LIT(PDD_NAME,"ECUART1");
#endif

#define KMaxEntryCount 5
#define KPortValue 110
#define KSmtpPortValue 25
#define KSize 100

_LIT(KPopServer, "nokia.com");
_LIT8(KPopPassword,"ban-User1");
_LIT8(KPopLoginName,"ban-User1");
_LIT(KTxtAccountName, "PopAccount");
_LIT(KSmtpServerAddress, "nokia.com");
_LIT(KEmailAlias, "Messaging example");

_LIT(KSmtpEmailAddress, "exampleUser1@nokia.com");

_LIT8(KFrom1, "exampleUser0@nokia.com");
_LIT(KTo1, "exampleUser1@nokia.com");
_LIT(KSubject1, "SimpleEmail");

_LIT(KBodyContents, "This is a very simple mail");

_LIT8(KFrom2, "exampleUser2@nokia.com");
_LIT(KTo2, "exampleUser3@nokia.com");
_LIT(KSubject2, "FunEmail");

_LIT8(KFrom3, "exampleUser4@nokia.com");
_LIT(KTo3, "exampleUser5@nokia.com");
_LIT(KSubject3, "SimpleEmail");

_LIT8(KFrom4, "exampleUser6@nokia.com");
_LIT(KTo4, "exampleUser7@nokia.com");
_LIT(KSubject4, "TestingMail");

_LIT8(KFrom5, "exampleUser8@nokia.com");
_LIT(KTo5, "exampleUser9@nokia.com");
_LIT(KSubject5, "GoodEmail");

_LIT(KSubjectSearch,"GoodEmail");

_LIT(KFormat1,"%D%M%Y%/0%1%/1%2%/2%3%/3");
_LIT(KFormat2,"%-B%:0%J%:1%T%:3%+B");
_LIT(KUserPanic,"Failed to complete");

/**
Query Table structure.
*/

typedef struct TQueryTable
	{
	TInt iQueryId;
	TMsvSearchSortResultType iResultType;
	}TQueryTable;


/**
Result Summary structure.
*/
typedef struct TResultSummary
	{
	TBuf<30> iToText;
	TBuf<30> iSubjectText;
	TBuf<30> iDatestring;
	TBuf<30> iTimestring;
	TInt iSize;
	}TResultSummary;

/**
CSearchsortExample.
*/

class CSearchsortExample : public  CBase,public MMsvSessionObserver
	{
public:
	static CSearchsortExample* NewL();

	// Destructor.
	~CSearchsortExample();

	// Creating client registry.
	void CreateClientRegistryL();

	//Creating pop and Smtp accounts and doing various server settings.
	void CreatePopAndSmtpAccountL();

	// Creating Smtp messages.
	void CreateSmtpMessageL(TInt aindex,TDes& aFrominfo,TDes& aToinfo,TDes& aSubjectinfo);

	// Function for search-sort using non-iterative mechanism.
	void SearchSortRequestWithoutIteratorL(TDes& aSender,TBool aCaseSensitivity,TBool aWholeWordSearch,TBool aCombinedSearch,TInt& aResultCount);

	// Function for search-sort using iterative mechanism.
	void SearchSortRequestWithIteratorL(TInt& aResultCount);

	// Function for search-sort by QueryID.
	void SearchSortRequestByQueryIdL(TInt& aResultCount);

	//  Overriden function of session event.
	void HandleSessionEventL(TMsvSessionEvent aEvent, TAny* aArg1, TAny* aArg2, TAny* aArg3);

	//Function for Smtp message entries deletion.
	void DeleteSmtpMessageL(); 
	
	//Function for email account deletion.
	void DeleteAccountsL() ;
private:

	// Constructor.
	CSearchsortExample();

	// 2nd phase construction.
	void ConstructL();
public:

	//Array for storing the search result.
	RArray<TResultSummary> iTResultSummary;
private:

	// Pointer to the Client-side MTM registry.
	CClientMtmRegistry* iClientRegistry;
	// Pointer to the channel of communication between a client thread and the Message Server thread.
	CMsvSession*		iSession;
	// ointer to the CBase MTM.
	CBaseMtm*			iMtm;
	// ID of the entry to access.
	TMsvId 				iPopServiceId;
	// POP account Name.
	TPopAccount			iPopAccount;
	// SMTP account Name.
	TSmtpAccount		iSmtpAccount;
	// Variable for storing the QueryID.
	TInt iQueryId;
	// Pointer to search sort operation.
	CMsvSearchSortOperation* iSearch;

	// TQueryTable member variable.
	TQueryTable iExampleTQueryTable;
	//Array for storing Query information.
	RArray<TQueryTable> iQueryIdTable;
	
	};

#endif // SEARCHSORTEXAMPLE_H
