// Copyright (c) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains CEzlibExample class.
//



/**
 @file
*/
#ifndef __EZLIBEXAMPLE_H__
#define __EZLIBEXAMPLE_H__

#include <zipfile.h>

/**
Demonstrates the use of the Symbian platform Ezlib component 
to zip and unzip .GZ files and unzip .ZIP files.
CEzlibExample publicly inherits from CBase, which is the 
base class for all classes to be instantiated on the heap.
*/
class CEzlibExample: public CBase
	{
public:
	static CEzlibExample* NewLC();

	~CEzlibExample();
	
	void OpenZipFileL(RFs& aFsSession);
	void GetPropertiesL(TFileName& aFileName, RFs& aFsSession);
	void ExtractFilesL(const CZipFileMember* aMember, CZipFile* aZipFile, RFs& aFsSession, const TDesC& aOutputPath);
	void CompressToGzipFileL(RFs& aFsSession);
	void ExtractGzipFileL(RFs& aFsSession);

private:
	CEzlibExample();
	void ConstructL();
private:
	/** Pointer to the console interface */
	CConsoleBase* iConsole;
    };

#endif //__EZLIBEXAMPLE_H__
