// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Defines the CAdder class.
//



/**
 @file
*/
#ifndef __ADDER_H__
#define __ADDER_H__

#include "sharedmem.h"

/**
The adder class.
This class creates the global chunk and periodically adds random values to it.
It also creates:
- the global condition variable
- the global mutex variable
- the timer object
The condition variable ensures that the value of the chunk is always less than 100.
*/
class CAdder : public CActive
	{
public:
	static CAdder* NewL(CConsoleBase* aConsole);
	void RunL();
	void DoCancel();
	~CAdder();
	void StartTimer();
	void StopTimer();
	void ReadFunction();
	static TInt AddFunction(TAny* aPtr);
	void Add();
private:
	CAdder();
	void ConstructL(CConsoleBase* aConsole);
private:
	/**
	The global condition variable.
	It ensures that the value of the shared chunk is always less than 100.
	*/
	RCondVar iCondVar;
	/**
	The mutex variable.
	*/
	RMutex iMutex;
	/**
	The global chunk shared between the adder and the subtractor processes.
	@see CSubtractor.
	*/
	RChunk iChunk;
	/**
	The timer object.
	It periodically invokes the AddFunction() function.
	*/
	CPeriodic* iPeriodic;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	};

#endif
