// Copyright (c) 2000-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// BitmapsGraphicsShell.h
//

#ifndef __BitmapsGraphicsShell_H
#define __BitmapsGraphicsShell_H

#include <coecntrl.h>
#include <coeccntx.h>

#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>

#include "BitmapsGraphicsControl.h"

// UID of app

const TUid KUidExampleShellApp={ 0xE800004F };

//
// TExampleShellModel
//

class TExampleShellModel
	{
public:
	TExampleShellModel();
	TBool Differs(const TExampleShellModel* aCompare) const;
public:
	TFileName iLibrary; // active control
	};

//
// class CExampleShellContainer
//

class CExampleShellContainer : public CCoeControl,
		public MCoeControlBrushContext,
		public MGraphicsExampleObserver
    {
public:
    void ConstructL(const TRect& aRect, TExampleShellModel* aModel);
    ~CExampleShellContainer();
	// changing view
	void ResetExampleL(CGraphicExampleControl* aExample);
private: // from CCoeControl
	void Draw(const TRect& /*aRect*/) const;
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
    TInt CountComponentControls() const;
    CCoeControl* ComponentControl(TInt aIndex) const;
private: // from MGraphicsExampleObserver
	void NotifyGraphicExampleFinished();
public: // also from MGraphicsExampleObserver
	void NotifyStatus(const TDesC& aMessage);
private: // new function
	void CreateLabelL();
private: // data
	CGraphicExampleControl* iExampleControl; // example control
	CEikLabel* iLabel; // label for status messages
	// irrelevant
	TExampleShellModel* iModel;
    };

//
// CExampleShellDocument
//

class CExampleShellDocument : public CEikDocument
	{
public:
	CExampleShellDocument(CEikApplication& aApp): CEikDocument(aApp) { }
	TExampleShellModel* Model() { return(&iModel); }
private: // from CEikDocument
	CEikAppUi* CreateAppUiL();
private:
	TExampleShellModel iModel;
	};

//
// CExampleShellAppUi
//

class CExampleShellAppUi : public CEikAppUi
    {
public:
    void ConstructL();
	~CExampleShellAppUi();
private: // from CEikAppUi
	void HandleCommandL(TInt aCommand);
private: // internal use
//	void PrepareToolbarButtons();
private:
    CExampleShellContainer* iContainer;
	TExampleShellModel* iModel;
    };

//
// CExampleShellApplication
//

class CExampleShellApplication : public CEikApplication
	{
private: // from CApaApplication
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
	};

#endif
