/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLEAPPUI_H
#define CALENDARAPIEXAMPLEAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknviewappui.h>

#include "CalendarAPIexampleEngine.h"

class CCalendarAPIexampleSearchView;
class CCalendarAPIexampleEntryView;
class CCalendarAPIexampleEntriesView;


// CLASS DECLARATION
/*!
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
* 
*/
class CCalendarAPIexampleAppUi : public CAknViewAppUi, 
                                 public MCalenderEngineObserverUI
    {
public: // // Constructors and destructor

   /*!
    * Symbian OS default constructor.
    */      
    void ConstructL();

   /*!
    * Destructor.
    */      
    ~CCalendarAPIexampleAppUi();
    
   /*!
    * Changes a view
    */
    void ActivateView(TUid aViewId);
        
private:
   /*!
    * From CEikAppUi, takes care of command handling.
    * param aCommand - command to be handled
    */
    void HandleCommandL(TInt aCommand);

private:
    CCalendarAPIexampleEngine*      iEngine;
    CCalendarAPIexampleSearchView*  iSearchView;
    CCalendarAPIexampleEntryView*   iEntryView;
    CCalendarAPIexampleEntriesView* iEntriesView;
    };

#endif

// End of File
