/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLEENTRIESCONTAINER_H
#define CALENDARAPIEXAMPLEENTRIESCONTAINER_H

// INCLUDE FILES
#include <coecntrl.h>   //CCoeControl
#include <eiktxlbx.h>   //CEikTextListBox
#include "CalendarAPIexampleEntriesView.h"
#include <aknlists.h> //CAknDoubleNumberStyleListBox

#include "CalendarAPIexampleEngine.h"
#include "CalendarAPIexampleEntriesView.h"

// CLASS DECLARATION

class CCalendarAPIexampleEntriesContainer : public CCoeControl,
                                            public MEikListBoxObserver
    {
public: // Constructors and destructor

   /*!
    * Two-phased constructor.
    */
    static CCalendarAPIexampleEntriesContainer* NewL(   
                                    const TRect& aRect,
                                    CCalendarAPIexampleEntriesView& aView,
                                    MCalendarEngineCommandsInterface& aEngine);
   /*!
    * Destructor.
    */
    ~CCalendarAPIexampleEntriesContainer();
    
private:

   /*!
    * Symbian OS Default constructor.
    */
    CCalendarAPIexampleEntriesContainer(CCalendarAPIexampleEntriesView& aView,
        MCalendarEngineCommandsInterface& aEngine);
    void ConstructL(const TRect& aRect);

public: // New functions

   /*!
    * CurrentItemIndex()
    *
    * Returns the index of the entry currently selected on the listbox.
    */
    TInt CurrentItemIndex() const;
    
   /*!
    * PopulateListBoxL()
    *
    * Requests all found entries from model and displays them in the listbox.
    */  
    void PopulateListBoxL();
    
private: // Functions from base classes

   /*!
    * From CoeControl,SizeChanged.
    */
    void SizeChanged();

    void HandleResourceChange(TInt aType);
    
   /*!
    * From CoeControl,CountComponentControls.
    */        
    TInt CountComponentControls() const; 
    
   /*!
    * From CCoeControl,ComponentControl.
    */
    CCoeControl* ComponentControl(TInt aIndex) const;
    
   /*!
    * From CCoeControl,OfferKeyEventL.
    */
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType );
    
   /*!
    * From MEikListBoxObserver,HandleListBoxEventL.
    */  
    void HandleListBoxEventL(CEikListBox* aListBox, TListBoxEvent aEventType);
    
private: // Data members
    CAknDoubleNumberStyleListBox*       iEntryListBox;
    CCalendarAPIexampleEntriesView&     iEntriesView;
    MCalendarEngineCommandsInterface&   iEngine;
    };

#endif
