/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLEENTRYVIEW_H
#define CALENDARAPIEXAMPLEENTRYVIEW_H

// INCLUDE FILES
#include <aknview.h>

#include "CalendarAPIexampleEngine.h"


// CONSTANTS
const TUid KEntryViewId = {2};

// FORWARD DECLARATIONS 
class CCalendarAPIexampleEntryContainer;
class CCalendarAPIexampleDocument;

// CLASS DECLARATION

class CCalendarAPIexampleEntryView : public CAknView
    {
public: // Constructors and destructor

   /*!
    * Two-phased constructor.
    */
    static CCalendarAPIexampleEntryView* NewL(MCalendarEngineCommandsInterface& aEngine);
    static CCalendarAPIexampleEntryView* NewLC(MCalendarEngineCommandsInterface& aEngine);

    CCalendarAPIexampleEntryView(
        MCalendarEngineCommandsInterface& aEngine);
   /*!
    * Default constructor.
    */
    void ConstructL();

   /*!
    * Destructor.
    */
    virtual ~CCalendarAPIexampleEntryView();

public: // From CAknView

   /*!
    * From CAknView, Id.
    * Returns ID of View.
    */
    TUid Id() const;

   /*!
    * From CAknView, HandleCommandL.
    * Handles the commands. If the command is command which is required to
    * display outline-screen, the command is reported to container class.
    * param aCommand - Command to be handled.
    */
    void HandleCommandL( TInt aCommand );
    
private: // New functions

   /*!
    * DoSaveL()
    *
    * Requests the model to save the current entry and 
    * then activates the proper view.
    */  
    void DoSaveL();
    
   /*!
    * DoDeleteL()
    *
    * Requests the model to delete the current entry and then 
    * activates the proper view.
    */  
    void DoDeleteL();

private: // From CAknView

   /*!
    * From CAknView, DoActivateL.
    * Creates the Container class object.
    * param aPrevViewId - aPrevViewId is not used.
    * param aCustomMessageId - aCustomMessageId is not used.
    * param aCustomMessage - aCustomMessage is not used.
    */
    void DoActivateL(   const TVwsViewId& aPrevViewId,
                        TUid aCustomMessageId,
                        const TDesC8& aCustomMessage );

   /*!
    * From CAknView, DoDeactivate.
    * Deletes the Container class object.
    */
    void DoDeactivate();

private: // Data members

    CCalendarAPIexampleEntryContainer* iContainer;
    //a reference to the engine through its public interface
    MCalendarEngineCommandsInterface& iEngine;
    TBool iModify;
    
    };
#endif
