/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLESEARCHCONTAINER_H
#define CALENDARAPIEXAMPLESEARCHCONTAINER_H

// INCLUDE FILES
#include <coecntrl.h>   //CCoeControl
#include <eiktxlbx.h>   //CEikTextListBox
#include <eikprogi.h>   //CEikProgressInfo
#include "CalendarAPIexampleEngine.h"
#include "CalendarAPIexampleSearchView.h"
#include <aknlists.h> //CAknSingleStyleListBox
#include <eiklbo.h>


// CLASS DECLARATION
    
class CCalendarAPIexampleSearchContainer :  public CCoeControl,
                                            public MEikListBoxObserver
    {
public: // Constructors and destructor

   /*!
    * Two-phased constructor.
    */
    static CCalendarAPIexampleSearchContainer* NewL(
                                    const TRect& aRect,
                                    CCalendarAPIexampleSearchView& aView);

   /*!
    * Destructor.
    */
    virtual ~CCalendarAPIexampleSearchContainer();

private : 
   
   /*!
    * Symbian OS default constructor.
    */
    CCalendarAPIexampleSearchContainer(CCalendarAPIexampleSearchView& aView);
    void ConstructL(const TRect& aRect);
    
public: // New functions
        
   /*!
    * SearchType()
    *
    * Returns the search range that is currently selected in the
    * listbox (week, month,...)
    */  
    TSearchType SearchType() const;
     
private: // Functions from base classes

    void SizeChanged(); 
    void HandleResourceChange(TInt aType);

   /*!
    * From CCoeControl,Draw.
    */
    void Draw(const TRect& aRect) const;
    
   /*!
    * From CCoeControl,OfferKeyEventL.
    */
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType );
    
   /*!
    * From MEikListBoxObserver,HandleListBoxEventL.
    */  
    void HandleListBoxEventL(CEikListBox* aListBox, TListBoxEvent aEventType);   

private: // Data members
    CAknSingleStyleListBox*                 iSearchListBox;
    CCalendarAPIexampleSearchView&          iSearchView;
    };

#endif
