/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef CALENDARAPIEXAMPLESEARCHVIEW_H
#define CALENDARAPIEXAMPLESEARCHVIEW_H

// INCLUDE FILES
#include <aknview.h>
#include "CalendarAPIexampleEngine.h"
// CONSTANTS
const TUid KSearchViewId = {1};

// FORWARD DECLARATIONS
class CCalendarAPIexampleSearchContainer;
//class CCalendarAPIexampleDocument;


// CLASS DECLARATION

class CCalendarAPIexampleSearchView : public CAknView
    {
public: // Constructors and destructor

   /*!
    * Two-phased constructor.
    */
    static CCalendarAPIexampleSearchView* NewL(MCalendarEngineCommandsInterface& aEngine);
    static CCalendarAPIexampleSearchView* NewLC(MCalendarEngineCommandsInterface& aEngine);

    CCalendarAPIexampleSearchView(MCalendarEngineCommandsInterface& aEngine);
   /*!
    * Default constructor.
    */
    void ConstructL();

   /*!
    * Destructor.
    */
    virtual ~CCalendarAPIexampleSearchView();

public: // From CAknView

   /*!
    * From CAknView, Id.
    * Returns ID of View.
    */
    TUid Id() const;

   /*!
    * From CAknView, HandleCommandL.
    * Handles the commands. If the command is command which is required to
    * display outline-screen, the command is reported to container class.
    * param aCommand - Command to be handled.
    */
    void HandleCommandL( TInt aCommand );
   
private: // New functions

   /*!
    * DoSearchL()
    *
    * Requests the model to do an entry search. Activates the proper view
    * for found entries.
    */  
    void DoSearchL();
    
   /*!
    * DoAddL()
    *
    * Activates the proper view for adding entries.
    */      
    void DoAddL();

private: // From CAknView

   /*!
    * From CAknView, DoActivateL.
    * Creates the Container class object.
    * param aPrevViewId - aPrevViewId is not used.
    * param aCustomMessageId - aCustomMessageId is not used.
    * param aCustomMessage - aCustomMessage is not used.
    */
    void DoActivateL(   const TVwsViewId& aPrevViewId,
                        TUid aCustomMessageId,
                        const TDesC8& aCustomMessage );

   /*!
    * From CAknView, DoDeactivate.
    * Deletes the Container class object.
    */
    void DoDeactivate();
    
 

private: // Data members

    CCalendarAPIexampleSearchContainer* iContainer;
    //a reference to the engine through its public interface
    MCalendarEngineCommandsInterface& iEngine;
 
    
    };
#endif
