/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __CALHELPERENTRY_H__
#define __CALHELPERENTRY_H__

// CLASS DECLARATION

#include "CalendarAPIexample.hrh"
#include <e32base.h>

class CCalEntry;
class CCalInstance;
class CCalAlarm;

/*!
 *   CCalHelperEntry - wrapper class for handling CCalEntrys and
 *   CCalInstances.
 */
class CCalHelperEntry : public CBase
    {
public: // Constructors and destructor
   /*!
    * Two-phased constructor.
    */
    static CCalHelperEntry* NewL(CCalEntry* aAnniv);
    static CCalHelperEntry* NewLC(CCalEntry* aAnniv);

    static CCalHelperEntry* NewL(CCalInstance* aAnniv);
    static CCalHelperEntry* NewLC(CCalInstance* aAnniv);

   /*!
    * Destructor.
    */
    ~CCalHelperEntry();

public:

   /*!
    * NewAnnivLC()
    *
    * Creates a new CCalEntry object, initializes it with 
    * entrys data and returns it.
    */
    CCalEntry* NewAnnivLC();

   /*!
    * SaveValuesL()
    *
    * Sets entrys values to entrys member CCalEntry object (iAnniv). 
    * Use SaveValuesL first
    * to set values to entry. Call to SaveValuesL is 
    * required only just before anniversary
    * is added or updated to the agenda file.
    */
    void SaveValuesL();

   /*!
    * SetValuesL()
    *
    * Sets given values to entry. Returns ETrue if values are valid, 
    * EFalse if not.
    * After setting values, use SaveValuesL() to set entrys
    * values to entrys member CCalEntry object (iAnniv).
    * param aName - name of description of anniversary.
    * param aAge - age of the anniversary
    * param aDate - date when the anniversary occurs.
    * param aAlarm - defines whether the anniversary has an alarm
    * param aAlarmTime - time when the alarm goes off.
    * param aSynchronizationMethod - defines how the anniversary 
    * is synchronized with e.g. PC.
    */
    TBool SetValues(   const TDesC& aName,
                        const TDateTime& aDate,
                        const TBool& aAlarm,
                        const TDateTime& aAlarmTime,
                        const TInt& aSynchronizationMethod);

    // Getters
    TBuf<KMaxNameLength> Name() const;
    TDateTime Date() const;
    TBool Alarm() const;
    TDateTime AlarmTime() const;
    TInt SynchronizationMethod() const;
    CCalEntry* Anniv();
    TBool Modified() const;
    TBool DateHasChanged() const;

private:
   /*!
    * Symbian OS default constructor.
    */
    CCalHelperEntry();
    void ConstructL(CCalEntry* aAnniv);
    void ConstructL(CCalInstance* aAnniv);

   /*!
    * CreateAnnivL()
    *
    * Creates a new CCalEntry object and returns it.
    */
    CCalEntry* CreateAnnivL();

   /*!
    * ResetTimeL()
    *
    * Sets given dates time to midnight.
    * param aDate - date to be reset.
    */
    void ResetTimeL(TDateTime& aDate) const;

   /*!
    * GetDaysAndMinutesL()
    *
    * Calculates how many days and minutes aTime is from aFromTime
    * param aTime - time that is compared to aFromTime.
    * param aFromTime - time that aTime is compared to.
    * param aDays - Calculated days.
    * param aMinutes - Calculated.
    */
    void GetDaysAndMinutesL(const TDateTime& aTime,
                                    const TDateTime& aFromTime,
                                    TTimeIntervalDays& aDays,
                                    TTimeIntervalMinutes& aMinutes) const;


   /*!
    * Setters()
    *
    * Sets values to member variables, and also checks has the data changed.
    * If data has changed, iModified is set ETrue.
    */
    void SetName(const TDesC& aName);
    void SetDate(const TDateTime& aDate);
    void SetAlarm(const TBool& aAlarm);
    void SetSynchronizationMethod(const TInt& aSynchronizationMethod);

    void SaveValuesToAnnivL(CCalEntry* aAnniv);


private: // data members

    TBuf<KMaxNameLength> iName;
    TDateTime iDate;
    CCalAlarm* iAlarmPtr;
    TBool iAlarm;
    TDateTime iAlarmTime;
    TInt iSynchronizationMethod;
    TTimeIntervalDays iAlarmDays;
    TTimeIntervalMinutes iAlarmMinutes;
    TBool iModified;
    TBool iDateModified;

    CCalEntry* iAnniv;
    CCalInstance* iInstance;
    };
#endif //__CALHELPERENTRY_H__
