/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <CalendarAPIexample.rsg> 
#include "CalendarAPIexampleEntryContainer.h"
#include "CalendarAPIexample.hrh"
#include "CalendarAPIexampleEntryItemList.h"
#include "CalendarAPIexampleDocument.h"


// ================= MEMBER FUNCTIONS =======================

// constructor
CCalendarAPIexampleEntryContainer::CCalendarAPIexampleEntryContainer()
    {
    }

// destructor
CCalendarAPIexampleEntryContainer::~CCalendarAPIexampleEntryContainer()
    {
    delete iItemList;
    iItemList=NULL;
    }

// Two-phased constructor.  
CCalendarAPIexampleEntryContainer* CCalendarAPIexampleEntryContainer::NewL(
                            const TRect& aRect, 
                            const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync)
    {
    CCalendarAPIexampleEntryContainer* self = 
        new (ELeave) CCalendarAPIexampleEntryContainer();
    CleanupStack::PushL(self);
    self->ConstructL(aRect, aName, aDate,aAlarm, aAlarmTime, aSync);
    CleanupStack::Pop(self);
    return self;
    }

// Symbian OS default constructor can leave.    
void CCalendarAPIexampleEntryContainer::ConstructL(
                            const TRect& aRect,
                            const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync)
    {
    CreateWindowL();    

    iItemList = new (ELeave) CCalendarAPIexampleEntryItemList();
    iItemList->SetContainerWindowL(*this); 

    SetValues(aName, aDate,aAlarm, aAlarmTime, aSync);
    //This results in a call to CreateSettingItemL
    //So the data should be there already   
    iItemList->ConstructFromResourceL(R_ENTRY_SETTINGS_LIST); 
    
    SetRect(aRect);
    ActivateL();    
    }

void CCalendarAPIexampleEntryContainer::SizeChanged()
    {
    iItemList->SetRect(Rect());
    iItemList->ListBox()->SetRect(Rect());
    }

void CCalendarAPIexampleEntryContainer::HandleResourceChange(TInt aType)
    {
    CCoeControl::HandleResourceChange(aType);
    if ( aType==KEikDynamicLayoutVariantSwitch )
        {
        TRect rect;
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane, rect);
        SetRect(rect);
        }
    }


// ----------------------------------------------------
// CCalendarAPIexampleEntryContainer::CountComponentControls()
// Gets the number of controls contained in a compound 
// control. 
// ----------------------------------------------------
//          
TInt CCalendarAPIexampleEntryContainer::CountComponentControls() const
    {
    TInt count = 0;
    if (iItemList)
        count++;
    return count;
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntryContainer::ComponentControl()
// Gets the specified component of a compound control.
// ----------------------------------------------------
//  
CCoeControl* CCalendarAPIexampleEntryContainer::ComponentControl(
                                                                TInt /*aIndex*/
                                                                ) const
    {
    return iItemList;
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntryContainer::OfferKeyEventL()
// When a key event occurs, the control framework calls 
// this function for each control on the control stack, 
// until one of them can process the key event 
// (and returns EKeyWasConsumed).
// ----------------------------------------------------
//  
TKeyResponse CCalendarAPIexampleEntryContainer::OfferKeyEventL( 
                                                const TKeyEvent& aKeyEvent, 
                                                TEventCode aType )
    {
    if(aType != EEventKey)
        {
        return EKeyWasNotConsumed;
        }    
    else if(iItemList)
        {
        return iItemList->OfferKeyEventL( aKeyEvent, aType );
        }
    else
        {
        return EKeyWasNotConsumed;
        }
    
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntryContainer::SaveL()
// Calls the itemlist to save its values to containers
// member entry object
// ----------------------------------------------------
//  
TBool CCalendarAPIexampleEntryContainer::SaveL()
    {   
    return iItemList->SaveL();
    }
    
void CCalendarAPIexampleEntryContainer::GetValues(
                                TDes& aName, TTime& aDate,
                                TBool& aAlarm, TTime& aAlarmTime, 
                                TInt& aSync)
    {
    iItemList->GetValues(aName,aDate,aAlarm,aAlarmTime,aSync);
    }

void CCalendarAPIexampleEntryContainer::SetValues(
                            const TDesC& aName,
                            const TDateTime& aDate,
                            const TBool& aAlarm,
                            const TDateTime& aAlarmTime,
                            const TInt& aSync)                               
    {
    iItemList->SetValues(aName,aDate,aAlarm,aAlarmTime,aSync);
    }    

// End of File
