/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <eikstart.h>
#include    "CalendarAPIexampleApp.h"
#include    "CalendarAPIexampleDocument.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CCalendarAPIexampleApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CCalendarAPIexampleApp::AppDllUid() const
    {
    return KUidCalendarAPIexample;
    }

   
// ---------------------------------------------------------
// CCalendarAPIexampleApp::CreateDocumentL()
// Creates CCalendarAPIexampleDocument object
// ---------------------------------------------------------
//
CApaDocument* CCalendarAPIexampleApp::CreateDocumentL()
    {
    return CCalendarAPIexampleDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication() 
// Constructs CCalendarAPIexampleApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return (static_cast<CApaApplication*>(new CCalendarAPIexampleApp));
    }
// ---------------------------------------------------------
// E32Main() 
// Entry point function for Symbian OS Apps
// Returns: TInt
// ---------------------------------------------------------
//
GLDEF_C TInt E32Main()
    {
    return EikStart::RunApplication( NewApplication );
    }

// End of File  

