/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <aknviewappui.h>
#include <AknQueryDialog.h> // CAknQueryDialog
#include <CalendarAPIexample.rsg>
#include "CalendarAPIexampleEntriesView.h"
#include "CalendarAPIexampleEntriesContainer.h"
#include "CalendarAPIexample.hrh"
#include "CalendarAPIexampleSearchView.h"
#include "CalendarAPIexampleEntryView.h"
#include "CalendarAPIexampleDocument.h"

// CONSTANTS
_LIT(KDeleteConfirmation, "Delete the selected anniversary?");

// ================= MEMBER FUNCTIONS =======================


// Two-phased constructor.
CCalendarAPIexampleEntriesView* CCalendarAPIexampleEntriesView::NewL(MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleEntriesView* self = CCalendarAPIexampleEntriesView::NewLC(aEngine);
    CleanupStack::Pop(self);
    return self;
    }

// Two-phased constructor.
CCalendarAPIexampleEntriesView* CCalendarAPIexampleEntriesView::NewLC(MCalendarEngineCommandsInterface& aEngine)
    {
    CCalendarAPIexampleEntriesView* self = new (ELeave) CCalendarAPIexampleEntriesView(aEngine);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }


CCalendarAPIexampleEntriesView::CCalendarAPIexampleEntriesView(
    MCalendarEngineCommandsInterface& aEngine) : iEngine(aEngine)
    {
       
    }



// destructor
CCalendarAPIexampleEntriesView::~CCalendarAPIexampleEntriesView()
    {
    delete iContainer;
    iContainer = NULL;
    }
    
// Symbian OS default constructor can leave.
void CCalendarAPIexampleEntriesView::ConstructL()
    {
    BaseConstructL(R_CALENDARAPIEXAMPLE_ENTRIES_VIEW);  
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesView::Id()
// Returns ID of View
// ----------------------------------------------------
//  
TUid CCalendarAPIexampleEntriesView::Id() const
    {
    return KEntriesViewId;
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesView::HandleCommandL()
// Takes care of command handling
// ----------------------------------------------------
//  
void CCalendarAPIexampleEntriesView::HandleCommandL( TInt aCommand )
    {
    switch (aCommand)
        {
        case ECalendarAPIexampleCmdEdit:
            DoEditL();
            break;
        case ECalendarAPIexampleCmdDelete:
            DoDeleteL();
            break;
        case EAknSoftkeyBack:
            AppUi()->ActivateLocalViewL(KSearchViewId);
            break;
        default:
            break;
        }
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesView::DoActivateL()
// Gets called when the view is activated. Creates 
// the entries container, adds it to view control stack
// and sets it visible.
// ----------------------------------------------------
//  
void CCalendarAPIexampleEntriesView::DoActivateL(
                                        const TVwsViewId& /*aPrevViewId*/,
                                        TUid /*aCustomMessageId*/,
                                        const TDesC8& /*aCustomMessage*/ )
    {
    if ( !iContainer )
        {
        iContainer = CCalendarAPIexampleEntriesContainer::NewL(
                                                ClientRect(), *this, iEngine);
        iContainer->SetMopParent(this);

        // Adds Container to View control stack.
        AppUi()->AddToStackL( *this, iContainer );

        // Requires to display the default screen.
        iContainer->MakeVisible( ETrue );        
        }       
    }
    
// ----------------------------------------------------
// CCalendarAPIexampleEntriesView::DoDeactivate()
// Gets called when the view is deactivated. Removes
// the entries container from view control stack and
// deletes it.
// ----------------------------------------------------
//      
void CCalendarAPIexampleEntriesView::DoDeactivate()
    {
    if ( iContainer )
        {
        // Removes Container from View control stack.
        AppUi()->RemoveFromStack(iContainer );
        }

    delete iContainer;
    iContainer = NULL;
    
    }    

// ----------------------------------------------------
// CCalendarAPIexampleEntriesView::DoDeleteL()
// Deletes the selected entry. If the last entry in the
// list was deleted, search view is activated, otherwise
// list is reloaded.
// ----------------------------------------------------
//  Called from This views handleCommandL
void CCalendarAPIexampleEntriesView::DoDeleteL()
    {
    CAknQueryDialog* query = CAknQueryDialog::NewL();
    CleanupStack::PushL(query);
    query->SetPromptL(KDeleteConfirmation);
    CleanupStack::Pop(query);
    if (query->ExecuteLD(R_CALENDARAPIEXAMPLE_CONFIRMATION_QUERY))
        {
        iEngine.DeleteEntryL(iContainer->CurrentItemIndex());
        
        // No more entries exist in the listbox, activate search view
        if (iEngine.EntryCount() == 0)
            {
            AppUi()->ActivateLocalViewL(KSearchViewId);
            }
        // reload listbox after deletion
        else
            {
            iContainer->PopulateListBoxL();
            }
        }
    }

// ----------------------------------------------------
// CCalendarAPIexampleEntriesView::DoEditL()
// Tell model which entry is to be edited and activate
// entry view.
// ----------------------------------------------------
//  
void CCalendarAPIexampleEntriesView::DoEditL()
    {
    iEngine.SetModifyIndex(iContainer->CurrentItemIndex());
    AppUi()->ActivateLocalViewL(KEntryViewId);
    }

// End of File
